/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.analyzer.CDOFetchRuleManagerThreadLocal;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDOAbstractFeatureRuleAnalyzer
implements CDOFeatureAnalyzer,
CDOFetchRuleManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOAbstractFeatureRuleAnalyzer.class);
    protected EStructuralFeature lastTraverseFeature;
    protected int lastTraverseIndex;
    protected long lastAccessTime;
    protected long lastElapseTimeBetweenOperations;
    protected CDOObject lastTraverseCDOObject;
    protected long lastLatencyTime;
    protected CDOCollectionLoadingPolicy loadCollectionPolicy;
    private boolean didFetch;
    private int fetchCount;

    public int getFetchCount() {
        return this.fetchCount;
    }

    public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
        return this.loadCollectionPolicy;
    }

    public void preTraverseFeature(CDOObject cdoObject, EStructuralFeature feature, int index) {
        if (TRACER.isEnabled()) {
            TRACER.format("preTraverseFeature : {0}.{1}", new Object[]{cdoObject.eClass(), feature.getName()});
        }
        this.loadCollectionPolicy = cdoObject.cdoView().getSession().options().getCollectionLoadingPolicy();
        this.lastTraverseFeature = feature;
        this.lastTraverseCDOObject = cdoObject;
        this.lastTraverseIndex = index;
        this.lastElapseTimeBetweenOperations = System.currentTimeMillis() - this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        this.didFetch = false;
        CDOFetchRuleManagerThreadLocal.join(this);
        this.doPreTraverseFeature(cdoObject, feature, index);
    }

    public void postTraverseFeature(CDOObject cdoObject, EStructuralFeature feature, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("postTraverseFeature : {0}.{1}", new Object[]{cdoObject.eClass(), feature.getName()});
        }
        try {
            this.doPostTraverseFeature(cdoObject, feature, index, value);
        }
        finally {
            CDOFetchRuleManagerThreadLocal.leave();
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    protected void doPreTraverseFeature(CDOObject cdoObject, EStructuralFeature feature, int index) {
    }

    protected void doPostTraverseFeature(CDOObject cdoObject, EStructuralFeature feature, int index, Object value) {
    }

    protected void fetchData() {
        this.didFetch = true;
        ++this.fetchCount;
    }

    protected boolean didFetch() {
        return this.didFetch;
    }
}

