/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.edit.ui.provider.ExtendedColorRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;

public class StyledStringConverter {
    private final Font defaultFont;
    private final Color defaultForeground;
    private final Color defaultBackground;

    public StyledStringConverter(Font defaultFont, Color defaultForeground, Color defaultBackground) {
        this.defaultFont = defaultFont;
        this.defaultForeground = defaultForeground;
        this.defaultBackground = defaultBackground;
    }

    public StyledString toJFaceStyledString(IStyledString.IComposedStyledString composedStyledString) {
        StyledString ret = new StyledString();
        for (IStyledString styledString : composedStyledString) {
            IStyledString.Style style = styledString.getStyle();
            String str = styledString.getString();
            if (style == IStyledString.Style.NO_STYLE) {
                ret.append(str);
                continue;
            }
            if (style == IStyledString.Style.COUNTER_STYLER) {
                ret.append(str, StyledString.COUNTER_STYLER);
                continue;
            }
            if (style == IStyledString.Style.DECORATIONS_STYLER) {
                ret.append(str, StyledString.DECORATIONS_STYLER);
                continue;
            }
            if (style == IStyledString.Style.QUALIFIER_STYLER) {
                ret.append(str, StyledString.QUALIFIER_STYLER);
                continue;
            }
            ret.append(str, this.toJFaceStyle(style));
        }
        return ret;
    }

    private StyledString.Styler toJFaceStyle(final IStyledString.Style style) {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = StyledStringConverter.this.getFont(style.getFont());
                textStyle.background = StyledStringConverter.this.getColor(style.getBackgoundColor());
                textStyle.foreground = StyledStringConverter.this.getColor(style.getForegroundColor());
                textStyle.strikeout = style.isStrikedout();
                textStyle.strikeoutColor = StyledStringConverter.this.getColor(style.getStrikeoutColor());
                textStyle.borderColor = StyledStringConverter.this.getColor(style.getBorderColor());
                switch (style.getBorderStyle()) {
                    case SOLID: {
                        textStyle.borderStyle = 1;
                        break;
                    }
                    case DOT: {
                        textStyle.borderStyle = 4;
                        break;
                    }
                    case DASH: {
                        textStyle.borderStyle = 2;
                        break;
                    }
                    case NONE: {
                        textStyle.borderStyle = 0;
                    }
                }
                if (style.getUnderlineStyle() != IStyledString.Style.UnderLineStyle.NONE) {
                    textStyle.underline = true;
                    textStyle.underlineColor = StyledStringConverter.this.getColor(style.getUnderlineColor());
                    switch (style.getUnderlineStyle()) {
                        case SINGLE: {
                            textStyle.underlineStyle = 0;
                            break;
                        }
                        case DOUBLE: {
                            textStyle.underlineStyle = 1;
                            break;
                        }
                        case ERROR: {
                            textStyle.underlineStyle = 2;
                            break;
                        }
                        case LINK: {
                            textStyle.underlineStyle = 4;
                            break;
                        }
                        case SQUIGGLE: {
                            textStyle.underlineStyle = 3;
                        }
                    }
                }
            }
        };
    }

    private Color getColor(URI colorURI) {
        return ExtendedColorRegistry.INSTANCE.getColor(this.defaultForeground, this.defaultBackground, (Object)colorURI);
    }

    private Font getFont(URI fontURI) {
        return ExtendedFontRegistry.INSTANCE.getFont(this.defaultFont, (Object)fontURI);
    }
}

