/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialogFactory;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialogInternal;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialogCallback;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialogInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IMustRemoveNonConformingElementsDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog.MustRemoveNonConformingElementsPromptDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog.SynchronizedMustRemoveNonConformingElementsPromptDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowedContentsETypedElementSelectionDialog
implements IAllowedContentsETypedElementSelectionDialogInternal {
    private IETypedElementSelectionDialogInternal typedElementSelectionDialog;
    private final Shell parentShell;
    private boolean mustRemoveNonConformingElements = true;
    private final IAllowedContentsETypedElementSelectionDialogCallback callback;
    private int returnCode = 1;
    private final Collection<? extends ETypedElement> typedElements;
    private final ICustomizationManager customizationManager;
    private boolean disableListener = false;

    protected void setMustRemoveNonConformingElements(boolean mustRemoveNonConformingElements) {
        this.mustRemoveNonConformingElements = mustRemoveNonConformingElements;
    }

    public AllowedContentsETypedElementSelectionDialog(Shell parentShell, Collection<? extends ETypedElement> typedElements, IAllowedContentsETypedElementSelectionDialogCallback dialogCallback, ICustomizationManager customizationManager) {
        this.parentShell = parentShell;
        this.typedElements = typedElements;
        this.callback = dialogCallback;
        this.customizationManager = customizationManager;
    }

    @Override
    public void open() {
        IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object> callback = new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> result, Object precommitResult) {
                if (AllowedContentsETypedElementSelectionDialog.this.isDisableListener()) {
                    return;
                }
                AllowedContentsETypedElementSelectionDialog.this.okPressed();
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        };
        Collection knownEPackages = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.customizationManager.getResourceSet()).getRegisteredFacetSets();
        this.typedElementSelectionDialog = (IETypedElementSelectionDialogInternal)IETypedElementSelectionDialogFactory.DEFAULT.openETypedElementSelectionDialog(AllowedContentsETypedElementSelectionDialog.filterAllowedElements(this.typedElements), 1, true, (IDialogCallbackWithPreCommit)callback, this.parentShell, this.customizationManager, knownEPackages);
    }

    private static Collection<? extends ETypedElement> filterAllowedElements(Collection<? extends ETypedElement> elements) {
        ArrayList<ETypedElement> filteredList = new ArrayList<ETypedElement>();
        for (ETypedElement eTypedElement : elements) {
            EClassifier eType;
            if (!AllowedContentsETypedElementSelectionDialog.extendsEObject(eTypedElement) || eTypedElement.getUpperBound() != 1 || eTypedElement.getLowerBound() != 1 && eTypedElement.getLowerBound() != 0 || AllowedContentsETypedElementSelectionDialog.hasParameters(eTypedElement) || !ModelUtils.isBooleanDataType((EClassifier)(eType = eTypedElement.getEType()))) continue;
            filteredList.add(eTypedElement);
        }
        return filteredList;
    }

    protected static boolean hasParameters(ETypedElement eTypedElement) {
        boolean result = false;
        if (eTypedElement instanceof EOperation) {
            EOperation operation = (EOperation)eTypedElement;
            result = operation.getEParameters().size() > 0;
        }
        return result;
    }

    private static boolean extendsEObject(ETypedElement eTypedElement) {
        Facet facet;
        boolean extendsEObject = false;
        if (eTypedElement.eContainer() instanceof Facet && (facet = (Facet)eTypedElement.eContainer()).getExtendedMetaclass() == EcorePackage.eINSTANCE.getEObject()) {
            extendsEObject = true;
        }
        return extendsEObject;
    }

    protected void typedElementSelectionDialogCanceled() {
        this.callback.canceled();
    }

    protected IMustRemoveNonConformingElementsDialog okPressed() {
        SynchronizedMustRemoveNonConformingElementsPromptDialog result;
        this.returnCode = 0;
        ETypedElement selectedETypedElement = this.typedElementSelectionDialog.getFirstSelectedETypedElement();
        if (this.typedElementSelectionDialog.getReturnCode() == 0) {
            if (this.callback.mustAskToRemoveNonAllowedElements(selectedETypedElement)) {
                final MustRemoveNonConformingElementsPromptDialog dialog = new MustRemoveNonConformingElementsPromptDialog(this.parentShell);
                dialog.addCloseListener(new Runnable(){

                    public void run() {
                        AllowedContentsETypedElementSelectionDialog.this.mustRemoveNonConformingElementsDialogClosed(dialog);
                    }
                });
                dialog.open();
                result = new SynchronizedMustRemoveNonConformingElementsPromptDialog(dialog);
            } else {
                this.callback.committed(this.getSelectedETypedElement(), false);
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    protected void mustRemoveNonConformingElementsDialogClosed(IMustRemoveNonConformingElementsDialog dialog) {
        ETypedElement selectedETypedElement = this.getSelectedETypedElement();
        if (selectedETypedElement != null) {
            boolean mustRemove = dialog.getMustRemoveNonConformingElements() != null && dialog.getMustRemoveNonConformingElements() != false;
            this.setMustRemoveNonConformingElements(mustRemove);
            this.callback.committed(selectedETypedElement, mustRemove);
        } else {
            this.callback.canceled();
        }
    }

    protected boolean isDisableListener() {
        return this.disableListener;
    }

    @Override
    public IMustRemoveNonConformingElementsDialog pressOk() {
        try {
            this.disableListener = true;
            this.typedElementSelectionDialog.pressOk();
        }
        finally {
            this.disableListener = false;
        }
        return this.okPressed();
    }

    @Override
    public void pressCancel() {
        this.typedElementSelectionDialog.pressCancel();
    }

    @Override
    public ETypedElement getSelectedETypedElement() {
        return this.typedElementSelectionDialog.getFirstSelectedETypedElement();
    }

    @Override
    public void select(ETypedElement typedElement) {
        if (typedElement == null) {
            this.typedElementSelectionDialog.setSelectedETypedElements(new ArrayList());
        } else {
            this.typedElementSelectionDialog.setSelectedETypedElements(Collections.singletonList(typedElement));
        }
    }

    @Override
    public boolean getMustRemoveNonConformingElements() {
        return this.mustRemoveNonConformingElements;
    }

    @Override
    public Shell getShell() {
        return this.parentShell;
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }
}

