/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit.actionbar;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.parsley.edit.action.EditingActionManager;
import org.eclipse.emf.parsley.edit.action.EditingDomainValidateAction;
import org.eclipse.emf.parsley.util.ActionBarsUtils;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

public class WorkbenchActionBarContributor
extends MultiPageEditorActionBarContributor
implements IMenuListener,
IPropertyListener,
ISelectionChangedListener {
    @Inject
    private EditingActionManager editingActionManager;
    private IWorkbenchPart activePart;
    private EditingDomainValidateAction validateAction;
    private ControlAction controlAction;
    private int style;
    private ISelectionProvider explicitSelectionProvider = null;
    private boolean actionsInitialized = false;
    public static final int ADDITIONS_LAST_STYLE = 1;

    public WorkbenchActionBarContributor() {
        this(1);
    }

    public WorkbenchActionBarContributor(int style) {
        this.style = style;
    }

    public void setExplicitSelectionProvider(ISelectionProvider explicitSelectionProvider) {
        this.explicitSelectionProvider = explicitSelectionProvider;
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        this.initializeActions(actionBars);
    }

    protected void initializeActions(IActionBars actionBars) {
        this.editingActionManager.initializeActions(actionBars);
        this.validateAction = this.editingActionManager.createValidateAction();
        this.controlAction = this.editingActionManager.createControlAction();
    }

    public void contributeToMenu(IMenuManager menuManager) {
        MenuManager submenuManager = new MenuManager("Emf Parsley", "org.eclipse.emf.parsley.MenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("ecore-settings"));
        toolBarManager.add((IContributionItem)new Separator("ecore-additions"));
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        this.editingActionManager.shareGlobalActions(page, actionBars);
    }

    public IEditorPart getActiveEditor() {
        if (this.activePart instanceof IEditorPart) {
            return (IEditorPart)this.activePart;
        }
        return null;
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.setActivePart((IWorkbenchPart)part);
    }

    public void setActivePart(IWorkbenchPart part) {
        if (!Objects.equal((Object)part, (Object)this.activePart)) {
            if (this.activePart != null) {
                this.deactivate();
            }
            if (part instanceof IEditingDomainProvider) {
                this.activePart = part;
                this.activate();
            }
        }
        this.activePart = part;
    }

    public void setActivePage(IEditorPart part) {
    }

    public void deactivate() {
        this.activePart.removePropertyListener((IPropertyListener)this);
        ISelectionProvider selectionProvider = this.retrieveSelectionProvider();
        if (selectionProvider != null) {
            if (this.controlAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
            if (this.validateAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
        }
    }

    public void activate() {
        ISelectionProvider selectionProvider;
        this.activePart.addPropertyListener((IPropertyListener)this);
        this.ensureActionsAreInitialized();
        if (this.activePart instanceof IEditingDomainProvider) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.activePart).getEditingDomain();
            this.editingActionManager.setEditingDomain(editingDomain);
            if (this.controlAction != null) {
                this.controlAction.setEditingDomain(editingDomain);
            }
            if (this.validateAction != null) {
                this.validateAction.setEditingDomain(editingDomain);
            }
        }
        if ((selectionProvider = this.retrieveSelectionProvider()) != null) {
            if (this.controlAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
            if (this.validateAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
        }
        this.update();
    }

    protected ISelectionProvider retrieveSelectionProvider() {
        if (this.explicitSelectionProvider != null) {
            return this.explicitSelectionProvider;
        }
        return this.activePart instanceof ISelectionProvider ? (ISelectionProvider)this.activePart : this.activePart.getSite().getSelectionProvider();
    }

    public void update() {
        ISelectionProvider selectionProvider = this.retrieveSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.editingActionManager.updateSelection((ISelection)structuredSelection);
            if (this.controlAction != null) {
                this.controlAction.updateSelection((IStructuredSelection)structuredSelection);
            }
            if (this.validateAction != null) {
                this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
            }
        }
        this.editingActionManager.updateUndoRedo();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        if ((this.style & 1) == 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
        }
        menuManager.add((IContributionItem)new Separator("edit"));
        this.ensureActionsAreInitialized();
        this.editingActionManager.menuAboutToShow(menuManager);
        if ((this.style & 1) != 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.addGlobalActions(menuManager);
        this.editingActionManager.emfMenuAboutToShow(menuManager);
    }

    protected void ensureActionsAreInitialized() {
        if (this.actionsInitialized) {
            return;
        }
        this.actionsInitialized = true;
        this.initializeActions(ActionBarsUtils.getActionBars(this.activePart));
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        String key;
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        String string = key = (this.style & 1) == 0 ? "additions-end" : "additions";
        if (this.validateAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.validateAction));
        }
        if (this.controlAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.controlAction));
        }
        if (this.validateAction != null || this.controlAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new Separator());
        }
    }

    public void propertyChanged(Object source, int id) {
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.editingActionManager.updateSelection(event.getSelection());
    }
}

