/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.swt.widgets.Shell;

public class EditableReportProcessorSafeWrapper extends ReportProcessorSafeWrapper implements IEditableReportProcessor {

    private IEditableReportProcessor reportProcessor;

    public EditableReportProcessorSafeWrapper(IEditableReportProcessor reportProcessor) {
        super(reportProcessor);
        this.reportProcessor = reportProcessor;
    }

    @Override
    public EditResult edit(IStatus status, IEclipseContext context, Shell parent) {
        try {
            return reportProcessor.edit(status, context, parent);
        } catch (Exception e) {
            Logs.log(LogMessages.WARN_REPORT_PROCESSOR_FAILED, reportProcessor, e);
        }
        return EditResult.CANCELED;
    }

    @Override
    public void reset(IStatus status, IEclipseContext context) {
        try {
            reportProcessor.reset(status, context);
        } catch (Exception e) {
            Logs.log(LogMessages.WARN_REPORT_PROCESSOR_FAILED, reportProcessor, e);
        }
    }

}
