/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.mars;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CancellationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;

public class HttpResponses {
    public static HttpEntity decorateForProgressMonitoring(HttpEntity entity, IProgressMonitor monitor) {
        return new HttpEntityProgressDecorator(entity, monitor);
    }

    public static HttpResponse getResponseWithProgress(Response response, IProgressMonitor monitor) throws ClientProtocolException, IOException {
        return (HttpResponse)response.handleResponse((ResponseHandler)new ProgressMonitorResponseHandler(monitor));
    }

    public static String getContentWithProgress(Response response, IProgressMonitor monitor) throws ClientProtocolException, IOException {
        return (String)response.handleResponse((ResponseHandler)new ProgressMonitorResponseStringHandler(monitor));
    }

    private static class ByteTransferProgress {
        private static final int PROGRESS_STEPS = 100;
        private IProgressMonitor monitor;
        private int monitorProgress;
        private int totalBytes;
        private int currentBytes;

        ByteTransferProgress(IProgressMonitor monitor, int byteLength) {
            this.totalBytes = byteLength;
            this.currentBytes = 0;
            this.monitorProgress = 0;
            this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        }

        public void transferred(int numBytes) {
            this.currentBytes += numBytes;
            int currentProgress = (int)(100.0 * ((double)this.currentBytes / (double)this.totalBytes));
            int newProgress = currentProgress - this.monitorProgress;
            if (newProgress > 0) {
                this.monitor.worked(newProgress);
                this.monitorProgress += newProgress;
                this.monitor.subTask(this.createProgressMessage(this.currentBytes, this.totalBytes));
            }
        }

        private String createProgressMessage(long transferredBytes, long totalBytes) {
            return Formats.format(Messages.JOB_PROGRESS_LABEL_HTTP, FileUtils.byteCountToDisplaySize((long)transferredBytes), FileUtils.byteCountToDisplaySize((long)totalBytes));
        }

        public boolean isMonitorCanceled() {
            return this.monitor.isCanceled();
        }
    }

    private static class HttpEntityProgressDecorator
    implements HttpEntity {
        HttpEntity entity;
        private IProgressMonitor monitor;

        HttpEntityProgressDecorator(HttpEntity entity, IProgressMonitor monitor) {
            this.entity = entity;
            this.monitor = monitor;
        }

        public boolean isRepeatable() {
            return this.entity.isRepeatable();
        }

        public boolean isChunked() {
            return this.entity.isChunked();
        }

        public long getContentLength() {
            return this.entity.getContentLength();
        }

        public Header getContentType() {
            return this.entity.getContentType();
        }

        public Header getContentEncoding() {
            return this.entity.getContentEncoding();
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return new ProgressMonitorInputStream(this.entity.getContent(), this.monitor, (int)this.getContentLength());
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.entity.writeTo((OutputStream)new ProgressMonitorOutputStream(outstream, this.monitor, (int)this.getContentLength()));
        }

        public boolean isStreaming() {
            return this.entity.isStreaming();
        }

        public void consumeContent() throws IOException {
            this.entity.consumeContent();
        }
    }

    private static class ProgressMonitorInputStream
    extends InputStream {
        private InputStream stream;
        private ByteTransferProgress progress;

        ProgressMonitorInputStream(InputStream stream, IProgressMonitor monitor, int byteLength) {
            this.stream = stream;
            this.progress = new ByteTransferProgress(monitor, byteLength);
        }

        @Override
        public int read() throws IOException {
            if (this.progress.isMonitorCanceled()) {
                throw new CancellationException();
            }
            this.progress.transferred(1);
            return this.stream.read();
        }

        public int hashCode() {
            return this.stream.hashCode();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return super.read(b, off, len);
        }

        public boolean equals(Object obj) {
            return this.stream.equals(obj);
        }

        @Override
        public long skip(long n) throws IOException {
            this.progress.transferred((int)n);
            return this.stream.skip(n);
        }

        public String toString() {
            return this.stream.toString();
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }

    private static class ProgressMonitorOutputStream
    extends OutputStream {
        private OutputStream stream;
        private ByteTransferProgress progress;

        ProgressMonitorOutputStream(OutputStream stream, IProgressMonitor monitor, int byteLength) {
            this.stream = stream;
            this.progress = new ByteTransferProgress(monitor, byteLength);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.progress.isMonitorCanceled()) {
                throw new CancellationException();
            }
            this.progress.transferred(1);
            this.stream.write(b);
        }

        public int hashCode() {
            return this.stream.hashCode();
        }

        @Override
        public void write(byte[] b) throws IOException {
            super.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
        }

        public boolean equals(Object obj) {
            return this.stream.equals(obj);
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        public String toString() {
            return this.stream.toString();
        }
    }

    private static class ProgressMonitorResponseHandler
    implements ResponseHandler<HttpResponse> {
        private IProgressMonitor monitor;

        ProgressMonitorResponseHandler(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public HttpResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            HttpEntity entity = HttpResponses.decorateForProgressMonitoring(response.getEntity(), this.monitor);
            if (response.getEntity() != null) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)entity));
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                byteArrayEntity.setContentType(contentType.toString());
                response.setEntity((HttpEntity)byteArrayEntity);
            }
            return response;
        }
    }

    private static class ProgressMonitorResponseStringHandler
    implements ResponseHandler<String> {
        private IProgressMonitor monitor;

        ProgressMonitorResponseStringHandler(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpResponse handled = new ProgressMonitorResponseHandler(this.monitor).handleResponse(response);
            return IOUtils.toString((InputStream)handled.getEntity().getContent());
        }
    }
}

