/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpContextInterceptor;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SynchronizedCredentialsProvider;

public class SynchronizedCredentialsProviderInterceptor
implements HttpContextInterceptor {
    public static final SynchronizedCredentialsProviderInterceptor INSTANCE = new SynchronizedCredentialsProviderInterceptor();

    public HttpContext intercept(HttpClient client, HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        CredentialsProvider credentialsProvider = clientContext.getCredentialsProvider();
        if (credentialsProvider instanceof SynchronizedCredentialsProvider) {
            return clientContext;
        }
        if (credentialsProvider != null) {
            credentialsProvider = new SynchronizedCredentialsProvider(credentialsProvider);
            clientContext.setCredentialsProvider(credentialsProvider);
        }
        return clientContext;
    }
}

