/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.io.IOException;
import java.net.URL;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ResourceProviderImageDescriptor
extends ImageDescriptor {
    private final String resourceName;
    private final ResourceProvider resourceProvider;
    private ImageDescriptor delegate;
    private boolean createDelegatePerformed = false;

    public ResourceProviderImageDescriptor(ResourceProvider resourceProvider, String resourceName) {
        this.resourceProvider = resourceProvider;
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    private ImageDescriptor getDelegate() {
        if (this.delegate == null && !this.createDelegatePerformed) {
            this.delegate = this.createDelegate();
            this.createDelegatePerformed = true;
        }
        return this.delegate;
    }

    private ImageDescriptor createDelegate() {
        ResourceProvider.ResourceFuture resource = this.resourceProvider.getResource(this.resourceName);
        if (resource != null) {
            URL url;
            try {
                url = resource.getURL();
            }
            catch (IOException iOException) {
                return null;
            }
            return this.createUrlDescriptor(url);
        }
        return null;
    }

    private ImageDescriptor createUrlDescriptor(URL url) {
        return ImageDescriptor.createFromURL((URL)url);
    }

    public Object createResource(Device device) throws DeviceResourceException {
        ImageDescriptor delegate = this.getDelegate();
        return delegate == null ? super.createResource(device) : delegate.createResource(device);
    }

    public void destroyResource(Object previouslyCreatedObject) {
        ImageDescriptor delegate = this.getDelegate();
        if (delegate != null) {
            delegate.destroyResource(previouslyCreatedObject);
        } else {
            super.destroyResource(previouslyCreatedObject);
        }
    }

    public Image createImage() {
        ImageDescriptor delegate = this.getDelegate();
        return delegate == null ? super.createImage() : delegate.createImage();
    }

    public Image createImage(boolean returnMissingImageOnError) {
        ImageDescriptor delegate = this.getDelegate();
        return delegate == null ? super.createImage(returnMissingImageOnError) : delegate.createImage(returnMissingImageOnError);
    }

    public Image createImage(Device device) {
        ImageDescriptor delegate = this.getDelegate();
        return delegate == null ? super.createImage(device) : delegate.createImage(device);
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        ImageDescriptor delegate = this.getDelegate();
        return delegate == null ? super.createImage(returnMissingImageOnError, device) : delegate.createImage(returnMissingImageOnError, device);
    }

    public ImageData getImageData() {
        ImageDescriptor delegate = this.getDelegate();
        return delegate == null ? null : delegate.getImageData();
    }
}

