/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.UserActionViewerItem;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseCatalogItem
extends UserActionViewerItem<CatalogDescriptor> {
    private static final String TID = "tid:";
    private static final String UTF_8 = "UTF-8";
    private final MarketplaceCategory category;
    private final IMarketplaceWebBrowser browser;

    public BrowseCatalogItem(Composite parent, DiscoveryResources resources, IShellProvider shellProvider, IMarketplaceWebBrowser browser, MarketplaceCategory category, CatalogDescriptor element, MarketplaceViewer viewer) {
        super(parent, resources, shellProvider, element, viewer);
        this.browser = browser;
        this.category = category;
        this.createContent();
    }

    @Override
    protected String getLinkText() {
        if (this.getViewer().getQueryContentType() == MarketplaceViewer.ContentType.SEARCH || this.getViewer().getQueryContentType() == MarketplaceViewer.ContentType.FEATURED_MARKET) {
            return NLS.bind((String)Messages.BrowseCatalogItem_browseMoreLink, (Object)this.category.getMatchCount());
        }
        return Messages.BrowseCatalogItem_browseMoreLinkNoCount;
    }

    @Override
    protected String getLinkToolTipText() {
        return NLS.bind((String)Messages.BrowseCatalogItem_openUrlBrowser, (Object)((CatalogDescriptor)this.getData()).getUrl());
    }

    @Override
    protected void actionPerformed(Object data) {
        this.openMarketplace();
    }

    protected void openMarketplace() {
        CatalogDescriptor catalogDescriptor = (CatalogDescriptor)this.getData();
        try {
            URL url = catalogDescriptor.getUrl();
            try {
                MarketplaceViewer.ContentType contentType = this.getViewer().getQueryContentType();
                if (contentType == MarketplaceViewer.ContentType.SEARCH) {
                    String queryText = this.getViewer().getQueryText();
                    ICategory queryCategory = this.getViewer().getQueryCategory();
                    IMarket queryMarket = this.getViewer().getQueryMarket();
                    String path = new DefaultMarketplaceService(url).computeRelativeSearchUrl(queryMarket, queryCategory, queryText, false);
                    if (path != null) {
                        url = new URL(url, path);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                MarketplaceClientUi.error(e);
            }
            catch (MalformedURLException e) {
                MarketplaceClientUi.error(e);
            }
            this.browser.openUrl(url.toURI().toString());
        }
        catch (URISyntaxException e) {
            String message = String.format(Messages.BrowseCatalogItem_cannotOpenBrowser, new Object[0]);
            Status status = new Status(4, "org.eclipse.epp.mpc.ui", 4, message, (Throwable)e);
            MarketplaceClientUi.handle((IStatus)status, 7);
        }
    }

    @Override
    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }
}

