/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.command;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.fx.ide.fxml.command.ControllerGenerator;
import org.eclipse.fx.ide.fxml.editors.Util;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXEventHandlerProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.fx.ide.ui.wizards.JDTElementFactory;
import org.eclipse.fx.ide.ui.wizards.template.JDTElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GenerateController
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null && document instanceof IStructuredDocument) {
            GenerateController.openDialog(textEditor, (IStructuredDocument)document);
        }
        return null;
    }

    private static void openDialog(ITextEditor arg0, IStructuredDocument document) {
        CreationDialog d;
        Object jp;
        int i;
        ArrayList<ControllerEntry<IFXClass>> fields = new ArrayList<ControllerEntry<IFXClass>>();
        ArrayList<ControllerEntry<IFXEventHandlerProperty>> methods = new ArrayList<ControllerEntry<IFXEventHandlerProperty>>();
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = document.getStructuredDocumentRegions();
        int n = iStructuredDocumentRegionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion region = iStructuredDocumentRegionArray[n2];
            ITextRegionList textRegions = region.getRegions();
            i = 0;
            while (i < textRegions.size()) {
                ITextRegion textRegion = textRegions.get(i);
                if (textRegion.getType() == "XML_TAG_OPEN") {
                    IndexedRegion treeNode = GenerateController.getNode((IDocument)document, region.getStartOffset(textRegion));
                    if (treeNode == null) {
                        return;
                    }
                    IDOMNode node = (IDOMNode)treeNode;
                    IFXClass e = GenerateController.computeTagNameHelp(node);
                    if (e != null) {
                        NamedNodeMap nnm = node.getAttributes();
                        Map props = e.getAllProperties();
                        int j = 0;
                        while (j < nnm.getLength()) {
                            Node attribute = nnm.item(j);
                            if (attribute.getNodeName().equals("fx:id")) {
                                fields.add(new ControllerEntry<IFXClass>(attribute.getNodeValue(), e, e, attribute.getNodeValue()));
                            } else {
                                IFXProperty p = (IFXProperty)props.get(attribute.getNodeName());
                                if (p instanceof IFXEventHandlerProperty) {
                                    String id = nnm.getNamedItem("fx:id") == null ? null : nnm.getNamedItem("fx:id").getNodeValue();
                                    methods.add(new ControllerEntry<IFXEventHandlerProperty>(id, e, (IFXEventHandlerProperty)p, attribute.getNodeValue()));
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            ++n2;
        }
        ControllerJDTElement clazz = new ControllerJDTElement();
        if (arg0.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fi = (FileEditorInput)arg0.getEditorInput();
            IFile file = fi.getFile();
            jp = JavaCore.create((IProject)file.getProject());
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getPackageFragmentRoots();
                int n3 = iPackageFragmentRootArray.length;
                i = 0;
                while (i < n3) {
                    IPackageFragmentRoot r = iPackageFragmentRootArray[i];
                    if (file.getFullPath().toString().startsWith(r.getPath().toString())) {
                        clazz.setFragmentRoot(r);
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
            try {
                clazz.setPackageFragment(jp.findPackageFragment(file.getParent().getFullPath()));
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            clazz.setName(String.valueOf(fi.getName().replace(".fxml", "")) + "Controller");
        }
        if ((d = new CreationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), clazz, fields, methods)).open() == 0 && clazz.getFragmentRoot() != null) {
            IFile file = GenerateController.createFile(clazz);
            if (!file.exists()) {
                try {
                    jp = null;
                    Object var8_14 = null;
                    try (ByteArrayInputStream in = new ByteArrayInputStream(new ControllerGenerator(clazz).generate().toString().getBytes());){
                        file.create((InputStream)in, true, null);
                    }
                    catch (Throwable throwable) {
                        if (jp == null) {
                            jp = throwable;
                        } else if (jp != throwable) {
                            ((Throwable)jp).addSuppressed(throwable);
                        }
                        throw jp;
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Failed to create file", (String)("Failure while create the controller file '" + e.getMessage() + "'"));
                }
            } else {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"File already exists", (String)"The controller file already exists. Updateing existing controllers is not supported!");
            }
        }
    }

    private static IFile createFile(ControllerJDTElement clazz) {
        IPackageFragment fragment = clazz.getPackageFragment();
        if (fragment != null) {
            String cuName = String.valueOf(clazz.getName()) + ".java";
            ICompilationUnit unit = fragment.getCompilationUnit(cuName);
            IResource resource = unit.getResource();
            return (IFile)resource;
        }
        String cuName = String.valueOf(clazz.getName()) + ".java";
        IFolder p = (IFolder)clazz.getFragmentRoot().getResource();
        return p.getFile(cuName);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IndexedRegion getNode(IDocument document, int documentOffset) {
        IndexedRegion node = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        if (mm != null) {
            model = mm.getExistingModelForRead(document);
        }
        try {
            block8: {
                int lastOffset;
                block7: {
                    if (model == null) return node;
                    lastOffset = documentOffset;
                    node = model.getIndexedRegion(documentOffset);
                    if (!true) break block7;
                    if (node != null) return node;
                    if (lastOffset < 0) break block8;
                }
                do {
                    node = model.getIndexedRegion(--lastOffset);
                    if (node != null) return node;
                } while (lastOffset >= 0);
            }
            return node;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static IFXClass computeTagNameHelp(IDOMNode xmlnode) {
        if (!Character.isLowerCase(xmlnode.getNodeName().charAt(0))) {
            if (xmlnode.getNodeName().contains(".")) {
                String[] parts = xmlnode.getNodeName().split("\\.");
                IType ownerType = Util.findType(parts[0], xmlnode.getOwnerDocument());
                if (ownerType != null) {
                    return FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType);
                }
            } else {
                IType ownerType = Util.findType(xmlnode.getNodeName(), xmlnode.getOwnerDocument());
                if (ownerType != null) {
                    return FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType);
                }
            }
        }
        return null;
    }

    static class ControllerEntry<T> {
        final IFXClass owner;
        final String ownerId;
        final T type;
        final String name;

        public ControllerEntry(String ownerId, IFXClass owner, T type, String name) {
            this.type = type;
            this.owner = owner;
            this.ownerId = ownerId;
            this.name = name;
        }
    }

    static class ControllerJDTElement
    extends JDTElement {
        private List<ControllerEntry<?>> entries = new ArrayList();

        ControllerJDTElement() {
        }

        public List<ControllerEntry<?>> getEntries() {
            return this.entries;
        }
    }

    static class CreationDialog
    extends TitleAreaDialog {
        final List<ControllerEntry<IFXClass>> fields;
        final List<ControllerEntry<IFXEventHandlerProperty>> methods;
        final ControllerJDTElement clazz;
        Image privateField = JavaPluginImages.DESC_FIELD_PRIVATE.createImage();
        Image publicMethod = JavaPluginImages.DESC_MISC_PUBLIC.createImage();
        private CheckboxTableViewer viewer;

        public CreationDialog(Shell parentShell, ControllerJDTElement clazz, List<ControllerEntry<IFXClass>> fields, List<ControllerEntry<IFXEventHandlerProperty>> methods) {
            super(parentShell);
            this.clazz = clazz;
            this.fields = fields;
            this.methods = methods;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            Composite area = new Composite(container, 0);
            area.setLayoutData((Object)new GridData(1808));
            area.setLayout((Layout)new GridLayout(3, false));
            DataBindingContext dbc = new DataBindingContext();
            JDTElementFactory.createSourceFolderElement((Composite)area, (DataBindingContext)dbc, (JDTElement)this.clazz, (IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            JDTElementFactory.createPackageElement((Composite)area, (DataBindingContext)dbc, (JDTElement)this.clazz);
            Label l = new Label(area, 0);
            l.setText("Name:");
            IWidgetValueProperty textProp = WidgetProperties.text((int)24);
            Text t = new Text(area, 2048);
            t.setLayoutData((Object)new GridData(768));
            dbc.bindValue((IObservableValue)textProp.observe((Widget)t), BeanProperties.value((String)"name", String.class).observe((Object)this.clazz));
            new Label(area, 0);
            l = new Label(area, 0);
            l.setText("Fields && Methods");
            l.setLayoutData((Object)new GridData(2));
            this.viewer = new CheckboxTableViewer(new Table(area, 68384));
            GridData gd = new GridData(1808);
            gd.heightHint = 200;
            this.viewer.getTable().setLayoutData((Object)gd);
            this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

                public void update(ViewerCell cell) {
                    ControllerEntry e = (ControllerEntry)cell.getElement();
                    if (e.type instanceof IFXClass) {
                        IFXClass c = (IFXClass)e.type;
                        StyledString s = new StyledString(e.name);
                        s.append(" : " + c.getSimpleName(), StyledString.QUALIFIER_STYLER);
                        cell.setText(s.getString());
                        cell.setStyleRanges(s.getStyleRanges());
                        cell.setImage(privateField);
                    } else {
                        IFXEventHandlerProperty p = (IFXEventHandlerProperty)e.type;
                        StyledString s = new StyledString(e.name.substring(1));
                        s.append(" : " + e.owner.getSimpleName() + (e.ownerId != null ? " [#" + e.ownerId + "]" : "") + " - " + p.getName() + "(" + p.getEventTypeAsString(false) + ")", StyledString.QUALIFIER_STYLER);
                        cell.setText(s.getString());
                        cell.setStyleRanges(s.getStyleRanges());
                        cell.setImage(publicMethod);
                    }
                    super.update(cell);
                }
            });
            ArrayList<ControllerEntry<Object>> combined = new ArrayList<ControllerEntry<Object>>();
            combined.addAll(this.fields);
            combined.addAll(this.methods);
            this.viewer.setInput(combined);
            this.viewer.setAllChecked(true);
            return container;
        }

        protected void okPressed() {
            Object[] objectArray = this.viewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.clazz.getEntries().add((ControllerEntry)o);
                ++n2;
            }
            super.okPressed();
        }

        public boolean close() {
            this.privateField.dispose();
            this.publicMethod.dispose();
            return super.close();
        }
    }
}

