/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import java.util.List;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.events.HoverTarget;
import org.eclipse.fx.ui.controls.styledtext.events.TextHoverEvent;
import org.eclipse.fx.ui.controls.styledtext.internal.ContentView;

public class HoverSupport {
    private Region control;
    private TextHoverEvent lastHover;
    private TextHoverEvent curHover;

    public HoverSupport(Region control) {
        this.control = control;
    }

    protected void install() {
        this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        this.control.addEventHandler(MouseEvent.MOUSE_MOVED, this::onMouseMoved);
        this.control.addEventHandler(MouseEvent.MOUSE_EXITED, this::onMouseExited);
        Util.installHoverCallback((Node)this.control, Duration.millis((double)300.0), this::handleHover);
    }

    public static HoverSupport install(Region control) {
        HoverSupport support = new HoverSupport(control);
        support.install();
        return support;
    }

    private void onMouseExited(MouseEvent event) {
        Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, -1, -1, -1, ""));
        this.lastHover = null;
        this.curHover = null;
    }

    private void onMouseMoved(MouseEvent event) {
        List<HoverTarget> hoverTargets;
        TextHoverEvent e;
        if (this.curHover != null && !(e = new TextHoverEvent(event, hoverTargets = ((ContentView)this.control).findHoverTargets(new Point2D(event.getX(), event.getY())))).equals((Object)this.curHover)) {
            Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, -1, -1, -1, ""));
            this.curHover = null;
        }
    }

    private void onMousePressed(MouseEvent event) {
        if (this.lastHover != null) {
            Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, -1, -1, -1, ""));
            this.lastHover = null;
            this.curHover = null;
        }
    }

    protected static TextHoverEvent createHoverEvent(MouseEvent e) {
        return new TextHoverEvent(e, -1, -1, -1, "");
    }

    protected void handleHover(MouseEvent event) {
        List<HoverTarget> hoverTargets = ((ContentView)this.control).findHoverTargets(new Point2D(event.getX(), event.getY()));
        TextHoverEvent e = new TextHoverEvent(event, hoverTargets);
        if (this.curHover == null || !e.equals((Object)this.curHover)) {
            Event.fireEvent((EventTarget)this.control, (Event)e);
            this.curHover = e;
        }
    }
}

