/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt.inject;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef4.common.adapt.IAdaptable;

public class AdaptableScope<A extends IAdaptable>
implements Scope {
    private Map<IAdaptable, Map<Key<?>, Object>> scopedInstances = new IdentityHashMap();
    private A adaptable = null;
    private Class<? extends A> type;

    public AdaptableScope(Class<? extends A> type) {
        this.type = type;
    }

    public void enter(A instance) {
        if (!this.scopedInstances.containsKey(instance)) {
            this.scopedInstances.put((IAdaptable)instance, new HashMap());
        }
        this.adaptable = instance;
    }

    public void leave(A instance) {
        if (this.scopedInstances.containsKey(instance)) {
            this.scopedInstances.remove(instance);
        }
        this.adaptable = null;
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                if (AdaptableScope.this.adaptable == null) {
                    throw new IllegalStateException("AdaptableScope for type '" + AdaptableScope.this.type + "' is not yet bound to an adaptable instance.");
                }
                Map scope = (Map)AdaptableScope.this.scopedInstances.get(AdaptableScope.this.adaptable);
                Object instance = scope.get(key);
                if (instance == null && (instance = unscoped.get()) != null) {
                    scope.put(key, instance);
                }
                return instance;
            }
        };
    }

    public void switchTo(A instance) {
        this.adaptable = instance;
    }
}

