/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt.inject;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.AdaptableTypeListener;

public class AdapterInjectionSupport
extends AbstractModule {
    private LoggingMode loggingMode = LoggingMode.DEVELOPMENT;

    public AdapterInjectionSupport() {
    }

    public AdapterInjectionSupport(LoggingMode loggingMode) {
        this.loggingMode = loggingMode;
    }

    protected void configure() {
        AdaptableTypeListener adaptableTypeListener = new AdaptableTypeListener(this.loggingMode);
        this.requestInjection(adaptableTypeListener);
        this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

            public boolean matches(TypeLiteral<?> t) {
                return IAdaptable.class.isAssignableFrom(t.getRawType());
            }
        }, adaptableTypeListener);
    }

    public static enum LoggingMode {
        DEVELOPMENT,
        PRODUCTION;

    }
}

