/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.property;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.beans.binding.MapExpressionHelperEx;

public class ReadOnlyMapWrapperEx<K, V>
extends ReadOnlyMapWrapper<K, V> {
    private MapExpressionHelperEx<K, V> helper = null;
    private ReadOnlyPropertyImplEx readOnlyProperty;

    public ReadOnlyMapWrapperEx() {
    }

    public ReadOnlyMapWrapperEx(Object bean, String name) {
        super(bean, name);
    }

    public ReadOnlyMapWrapperEx(Object bean, String name, ObservableMap<K, V> initialValue) {
        super(bean, name, initialValue);
    }

    public ReadOnlyMapWrapperEx(ObservableMap<K, V> initialValue) {
        super(initialValue);
    }

    public void addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        if (this.helper == null) {
            this.helper = new MapExpressionHelperEx(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        if (this.helper == null) {
            this.helper = new MapExpressionHelperEx(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(MapChangeListener<? super K, ? super V> listener) {
        if (this.helper == null) {
            this.helper = new MapExpressionHelperEx(this);
        }
        this.helper.addListener(listener);
    }

    public void bindBidirectional(Property<ObservableMap<K, V>> other) {
        try {
            super.bindBidirectional(other);
        }
        catch (IllegalArgumentException e) {
            if ("Cannot bind property to itself".equals(e.getMessage()) && this != other) {
                if (other.getValue() == null) {
                    if (this.getValue() == null) {
                        this.setValue(FXCollections.observableMap(new HashMap()));
                    }
                } else if (this.getValue().equals(other)) {
                    this.setValue(null);
                }
                super.bindBidirectional(other);
            }
            throw e;
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof Map)) {
            return false;
        }
        if (this.get() == null) {
            return false;
        }
        return this.get().equals(other);
    }

    protected void fireValueChangedEvent() {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent();
        }
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    protected void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent(change);
        }
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent(change);
        }
    }

    public ReadOnlyMapProperty<K, V> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImplEx();
        }
        return this.readOnlyProperty;
    }

    public int hashCode() {
        return 0;
    }

    public void removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(MapChangeListener<? super K, ? super V> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void unbindBidirectional(Property<ObservableMap<K, V>> other) {
        try {
            super.unbindBidirectional(other);
        }
        catch (IllegalArgumentException e) {
            if ("Cannot bind property to itself".equals(e.getMessage()) && this != other) {
                ObservableMap oldValue = this.getValue();
                if (other.getValue() == null) {
                    this.setValue(FXCollections.observableMap(new HashMap()));
                } else {
                    this.setValue(null);
                }
                super.unbindBidirectional(other);
                this.setValue(oldValue);
            }
            throw e;
        }
    }

    private class ReadOnlyPropertyImplEx
    extends ReadOnlyMapProperty<K, V> {
        private MapExpressionHelperEx<K, V> helper = null;

        private ReadOnlyPropertyImplEx() {
        }

        public void addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            if (this.helper == null) {
                this.helper = new MapExpressionHelperEx(this);
            }
            this.helper.addListener(listener);
        }

        public void addListener(InvalidationListener listener) {
            if (this.helper == null) {
                this.helper = new MapExpressionHelperEx(this);
            }
            this.helper.addListener(listener);
        }

        public void addListener(MapChangeListener<? super K, ? super V> listener) {
            if (this.helper == null) {
                this.helper = new MapExpressionHelperEx(this);
            }
            this.helper.addListener(listener);
        }

        public ReadOnlyBooleanProperty emptyProperty() {
            return ReadOnlyMapWrapperEx.this.emptyProperty();
        }

        private void fireValueChangedEvent() {
            if (this.helper != null) {
                this.helper.fireValueChangedEvent();
            }
        }

        private void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
            if (this.helper != null) {
                this.helper.fireValueChangedEvent(change);
            }
        }

        public ObservableMap<K, V> get() {
            return ReadOnlyMapWrapperEx.this.get();
        }

        public Object getBean() {
            return ReadOnlyMapWrapperEx.this.getBean();
        }

        public String getName() {
            return ReadOnlyMapWrapperEx.this.getName();
        }

        public void removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            if (this.helper != null) {
                this.helper.removeListener(listener);
            }
        }

        public void removeListener(InvalidationListener listener) {
            if (this.helper != null) {
                this.helper.removeListener(listener);
            }
        }

        public void removeListener(MapChangeListener<? super K, ? super V> listener) {
            if (this.helper != null) {
                this.helper.removeListener(listener);
            }
        }

        public ReadOnlyIntegerProperty sizeProperty() {
            return ReadOnlyMapWrapperEx.this.sizeProperty();
        }
    }
}

