/*
* generated by Xtext
*/
package org.eclipse.gef4.dot.internal.parser.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;


@Singleton
public class DotGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class DotAstElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DotAst");
		private final Assignment cGraphsAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cGraphsDotGraphParserRuleCall_0 = (RuleCall)cGraphsAssignment.eContents().get(0);
		
		//DotAst:
		//	graphs+=DotGraph*;
		public ParserRule getRule() { return rule; }

		//graphs+=DotGraph*
		public Assignment getGraphsAssignment() { return cGraphsAssignment; }

		//DotGraph
		public RuleCall getGraphsDotGraphParserRuleCall_0() { return cGraphsDotGraphParserRuleCall_0; }
	}

	public class DotGraphElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DotGraph");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cStrictAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cStrictStrictKeyword_0_0 = (Keyword)cStrictAssignment_0.eContents().get(0);
		private final Assignment cTypeAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cTypeGraphTypeEnumRuleCall_1_0 = (RuleCall)cTypeAssignment_1.eContents().get(0);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDParserRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cStmtsAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cStmtsStmtParserRuleCall_4_0 = (RuleCall)cStmtsAssignment_4.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//DotGraph:
		//	strict?="strict"? type=GraphType name=ID? "{" stmts+=Stmt* "}";
		public ParserRule getRule() { return rule; }

		//strict?="strict"? type=GraphType name=ID? "{" stmts+=Stmt* "}"
		public Group getGroup() { return cGroup; }

		//strict?="strict"?
		public Assignment getStrictAssignment_0() { return cStrictAssignment_0; }

		//"strict"
		public Keyword getStrictStrictKeyword_0_0() { return cStrictStrictKeyword_0_0; }

		//type=GraphType
		public Assignment getTypeAssignment_1() { return cTypeAssignment_1; }

		//GraphType
		public RuleCall getTypeGraphTypeEnumRuleCall_1_0() { return cTypeGraphTypeEnumRuleCall_1_0; }

		//name=ID?
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }

		//ID
		public RuleCall getNameIDParserRuleCall_2_0() { return cNameIDParserRuleCall_2_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }

		//stmts+=Stmt*
		public Assignment getStmtsAssignment_4() { return cStmtsAssignment_4; }

		//Stmt
		public RuleCall getStmtsStmtParserRuleCall_4_0() { return cStmtsStmtParserRuleCall_4_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_5() { return cRightCurlyBracketKeyword_5; }
	}

	public class StmtElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "Stmt");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final RuleCall cNodeStmtParserRuleCall_0_0 = (RuleCall)cAlternatives_0.eContents().get(0);
		private final RuleCall cEdgeStmtNodeParserRuleCall_0_1 = (RuleCall)cAlternatives_0.eContents().get(1);
		private final RuleCall cAttrStmtParserRuleCall_0_2 = (RuleCall)cAlternatives_0.eContents().get(2);
		private final RuleCall cAttributeParserRuleCall_0_3 = (RuleCall)cAlternatives_0.eContents().get(3);
		private final RuleCall cSubgraphOrEdgeStmtSubgraphParserRuleCall_0_4 = (RuleCall)cAlternatives_0.eContents().get(4);
		private final Keyword cSemicolonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//// XXX: We need to handle EdgeStmtSubgraph together with Subgraph, or the grammar would be ambiguous
		//Stmt:
		//	(NodeStmt | EdgeStmtNode | AttrStmt | Attribute | SubgraphOrEdgeStmtSubgraph) ";"?;
		public ParserRule getRule() { return rule; }

		//(NodeStmt | EdgeStmtNode | AttrStmt | Attribute | SubgraphOrEdgeStmtSubgraph) ";"?
		public Group getGroup() { return cGroup; }

		//NodeStmt | EdgeStmtNode | AttrStmt | Attribute | SubgraphOrEdgeStmtSubgraph
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//NodeStmt
		public RuleCall getNodeStmtParserRuleCall_0_0() { return cNodeStmtParserRuleCall_0_0; }

		//EdgeStmtNode
		public RuleCall getEdgeStmtNodeParserRuleCall_0_1() { return cEdgeStmtNodeParserRuleCall_0_1; }

		//AttrStmt
		public RuleCall getAttrStmtParserRuleCall_0_2() { return cAttrStmtParserRuleCall_0_2; }

		//Attribute
		public RuleCall getAttributeParserRuleCall_0_3() { return cAttributeParserRuleCall_0_3; }

		//SubgraphOrEdgeStmtSubgraph
		public RuleCall getSubgraphOrEdgeStmtSubgraphParserRuleCall_0_4() { return cSubgraphOrEdgeStmtSubgraphParserRuleCall_0_4; }

		//";"?
		public Keyword getSemicolonKeyword_1() { return cSemicolonKeyword_1; }
	}

	public class EdgeStmtNodeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EdgeStmtNode");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNodeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNodeNodeIdParserRuleCall_0_0 = (RuleCall)cNodeAssignment_0.eContents().get(0);
		private final Assignment cEdgeRHSAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cEdgeRHSEdgeRhsParserRuleCall_1_0 = (RuleCall)cEdgeRHSAssignment_1.eContents().get(0);
		private final Assignment cAttrListsAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cAttrListsAttrListParserRuleCall_2_0 = (RuleCall)cAttrListsAssignment_2.eContents().get(0);
		
		//EdgeStmtNode:
		//	node=NodeId edgeRHS+=EdgeRhs+ attrLists+=AttrList*;
		public ParserRule getRule() { return rule; }

		//node=NodeId edgeRHS+=EdgeRhs+ attrLists+=AttrList*
		public Group getGroup() { return cGroup; }

		//node=NodeId
		public Assignment getNodeAssignment_0() { return cNodeAssignment_0; }

		//NodeId
		public RuleCall getNodeNodeIdParserRuleCall_0_0() { return cNodeNodeIdParserRuleCall_0_0; }

		//edgeRHS+=EdgeRhs+
		public Assignment getEdgeRHSAssignment_1() { return cEdgeRHSAssignment_1; }

		//EdgeRhs
		public RuleCall getEdgeRHSEdgeRhsParserRuleCall_1_0() { return cEdgeRHSEdgeRhsParserRuleCall_1_0; }

		//attrLists+=AttrList*
		public Assignment getAttrListsAssignment_2() { return cAttrListsAssignment_2; }

		//AttrList
		public RuleCall getAttrListsAttrListParserRuleCall_2_0() { return cAttrListsAttrListParserRuleCall_2_0; }
	}

	public class EdgeStmtSubgraphElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EdgeStmtSubgraph");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cSubgraphAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cSubgraphSubgraphParserRuleCall_0_0 = (RuleCall)cSubgraphAssignment_0.eContents().get(0);
		private final Assignment cEdgeRHSAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cEdgeRHSEdgeRhsParserRuleCall_1_0 = (RuleCall)cEdgeRHSAssignment_1.eContents().get(0);
		private final Assignment cAttrListsAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cAttrListsAttrListParserRuleCall_2_0 = (RuleCall)cAttrListsAssignment_2.eContents().get(0);
		
		//EdgeStmtSubgraph:
		//	subgraph=Subgraph edgeRHS+=EdgeRhs+ attrLists+=AttrList*;
		public ParserRule getRule() { return rule; }

		//subgraph=Subgraph edgeRHS+=EdgeRhs+ attrLists+=AttrList*
		public Group getGroup() { return cGroup; }

		//subgraph=Subgraph
		public Assignment getSubgraphAssignment_0() { return cSubgraphAssignment_0; }

		//Subgraph
		public RuleCall getSubgraphSubgraphParserRuleCall_0_0() { return cSubgraphSubgraphParserRuleCall_0_0; }

		//edgeRHS+=EdgeRhs+
		public Assignment getEdgeRHSAssignment_1() { return cEdgeRHSAssignment_1; }

		//EdgeRhs
		public RuleCall getEdgeRHSEdgeRhsParserRuleCall_1_0() { return cEdgeRHSEdgeRhsParserRuleCall_1_0; }

		//attrLists+=AttrList*
		public Assignment getAttrListsAssignment_2() { return cAttrListsAssignment_2; }

		//AttrList
		public RuleCall getAttrListsAttrListParserRuleCall_2_0() { return cAttrListsAttrListParserRuleCall_2_0; }
	}

	public class NodeStmtElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NodeStmt");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNodeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNodeNodeIdParserRuleCall_0_0 = (RuleCall)cNodeAssignment_0.eContents().get(0);
		private final Assignment cAttrListsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cAttrListsAttrListParserRuleCall_1_0 = (RuleCall)cAttrListsAssignment_1.eContents().get(0);
		
		//NodeStmt:
		//	node=NodeId attrLists+=AttrList*;
		public ParserRule getRule() { return rule; }

		//node=NodeId attrLists+=AttrList*
		public Group getGroup() { return cGroup; }

		//node=NodeId
		public Assignment getNodeAssignment_0() { return cNodeAssignment_0; }

		//NodeId
		public RuleCall getNodeNodeIdParserRuleCall_0_0() { return cNodeNodeIdParserRuleCall_0_0; }

		//attrLists+=AttrList*
		public Assignment getAttrListsAssignment_1() { return cAttrListsAssignment_1; }

		//AttrList
		public RuleCall getAttrListsAttrListParserRuleCall_1_0() { return cAttrListsAttrListParserRuleCall_1_0; }
	}

	public class AttrStmtElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "AttrStmt");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cTypeAttributeTypeEnumRuleCall_0_0 = (RuleCall)cTypeAssignment_0.eContents().get(0);
		private final Assignment cAttrListsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cAttrListsAttrListParserRuleCall_1_0 = (RuleCall)cAttrListsAssignment_1.eContents().get(0);
		
		//AttrStmt:
		//	type=AttributeType attrLists+=AttrList+;
		public ParserRule getRule() { return rule; }

		//type=AttributeType attrLists+=AttrList+
		public Group getGroup() { return cGroup; }

		//type=AttributeType
		public Assignment getTypeAssignment_0() { return cTypeAssignment_0; }

		//AttributeType
		public RuleCall getTypeAttributeTypeEnumRuleCall_0_0() { return cTypeAttributeTypeEnumRuleCall_0_0; }

		//attrLists+=AttrList+
		public Assignment getAttrListsAssignment_1() { return cAttrListsAssignment_1; }

		//AttrList
		public RuleCall getAttrListsAttrListParserRuleCall_1_0() { return cAttrListsAttrListParserRuleCall_1_0; }
	}

	public class AttrListElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "AttrList");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cAttrListAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cLeftSquareBracketKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cAttributesAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cAttributesAttributeParserRuleCall_2_0_0 = (RuleCall)cAttributesAssignment_2_0.eContents().get(0);
		private final Alternatives cAlternatives_2_1 = (Alternatives)cGroup_2.eContents().get(1);
		private final Keyword cCommaKeyword_2_1_0 = (Keyword)cAlternatives_2_1.eContents().get(0);
		private final Keyword cSemicolonKeyword_2_1_1 = (Keyword)cAlternatives_2_1.eContents().get(1);
		private final Keyword cRightSquareBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//AttrList:
		//	{AttrList} "[" (attributes+=Attribute ("," | ";")?)* "]";
		public ParserRule getRule() { return rule; }

		//{AttrList} "[" (attributes+=Attribute ("," | ";")?)* "]"
		public Group getGroup() { return cGroup; }

		//{AttrList}
		public Action getAttrListAction_0() { return cAttrListAction_0; }

		//"["
		public Keyword getLeftSquareBracketKeyword_1() { return cLeftSquareBracketKeyword_1; }

		//(attributes+=Attribute ("," | ";")?)*
		public Group getGroup_2() { return cGroup_2; }

		//attributes+=Attribute
		public Assignment getAttributesAssignment_2_0() { return cAttributesAssignment_2_0; }

		//Attribute
		public RuleCall getAttributesAttributeParserRuleCall_2_0_0() { return cAttributesAttributeParserRuleCall_2_0_0; }

		//("," | ";")?
		public Alternatives getAlternatives_2_1() { return cAlternatives_2_1; }

		//","
		public Keyword getCommaKeyword_2_1_0() { return cCommaKeyword_2_1_0; }

		//";"
		public Keyword getSemicolonKeyword_2_1_1() { return cSemicolonKeyword_2_1_1; }

		//"]"
		public Keyword getRightSquareBracketKeyword_3() { return cRightSquareBracketKeyword_3; }
	}

	public class AttributeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "Attribute");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameIDParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueIDParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		
		//Attribute:
		//	name=ID "=" value=ID;
		public ParserRule getRule() { return rule; }

		//name=ID "=" value=ID
		public Group getGroup() { return cGroup; }

		//name=ID
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//ID
		public RuleCall getNameIDParserRuleCall_0_0() { return cNameIDParserRuleCall_0_0; }

		//"="
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }

		//value=ID
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }

		//ID
		public RuleCall getValueIDParserRuleCall_2_0() { return cValueIDParserRuleCall_2_0; }
	}

	public class SubgraphOrEdgeStmtSubgraphElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "SubgraphOrEdgeStmtSubgraph");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cSubgraphParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Action cEdgeStmtSubgraphSubgraphAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Assignment cEdgeRHSAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cEdgeRHSEdgeRhsParserRuleCall_1_1_0 = (RuleCall)cEdgeRHSAssignment_1_1.eContents().get(0);
		private final Assignment cAttrListsAssignment_1_2 = (Assignment)cGroup_1.eContents().get(2);
		private final RuleCall cAttrListsAttrListParserRuleCall_1_2_0 = (RuleCall)cAttrListsAssignment_1_2.eContents().get(0);
		
		//// XXX: We perform an assign action, so the parse tree is rewritten in case a subgraph is specified through an EdgeStmt
		//SubgraphOrEdgeStmtSubgraph:
		//	Subgraph ({EdgeStmtSubgraph.subgraph=current} edgeRHS+=EdgeRhs+ attrLists+=AttrList*)?;
		public ParserRule getRule() { return rule; }

		//Subgraph ({EdgeStmtSubgraph.subgraph=current} edgeRHS+=EdgeRhs+ attrLists+=AttrList*)?
		public Group getGroup() { return cGroup; }

		//Subgraph
		public RuleCall getSubgraphParserRuleCall_0() { return cSubgraphParserRuleCall_0; }

		//({EdgeStmtSubgraph.subgraph=current} edgeRHS+=EdgeRhs+ attrLists+=AttrList*)?
		public Group getGroup_1() { return cGroup_1; }

		//{EdgeStmtSubgraph.subgraph=current}
		public Action getEdgeStmtSubgraphSubgraphAction_1_0() { return cEdgeStmtSubgraphSubgraphAction_1_0; }

		//edgeRHS+=EdgeRhs+
		public Assignment getEdgeRHSAssignment_1_1() { return cEdgeRHSAssignment_1_1; }

		//EdgeRhs
		public RuleCall getEdgeRHSEdgeRhsParserRuleCall_1_1_0() { return cEdgeRHSEdgeRhsParserRuleCall_1_1_0; }

		//attrLists+=AttrList*
		public Assignment getAttrListsAssignment_1_2() { return cAttrListsAssignment_1_2; }

		//AttrList
		public RuleCall getAttrListsAttrListParserRuleCall_1_2_0() { return cAttrListsAttrListParserRuleCall_1_2_0; }
	}

	public class SubgraphElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "Subgraph");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSubgraphAction_0 = (Action)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cSubgraphKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cNameAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cNameIDParserRuleCall_1_1_0 = (RuleCall)cNameAssignment_1_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cStmtsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cStmtsStmtParserRuleCall_3_0 = (RuleCall)cStmtsAssignment_3.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//Subgraph:
		//	{Subgraph} ("subgraph" name=ID?)? "{" stmts+=Stmt* "}";
		public ParserRule getRule() { return rule; }

		//{Subgraph} ("subgraph" name=ID?)? "{" stmts+=Stmt* "}"
		public Group getGroup() { return cGroup; }

		//{Subgraph}
		public Action getSubgraphAction_0() { return cSubgraphAction_0; }

		//("subgraph" name=ID?)?
		public Group getGroup_1() { return cGroup_1; }

		//"subgraph"
		public Keyword getSubgraphKeyword_1_0() { return cSubgraphKeyword_1_0; }

		//name=ID?
		public Assignment getNameAssignment_1_1() { return cNameAssignment_1_1; }

		//ID
		public RuleCall getNameIDParserRuleCall_1_1_0() { return cNameIDParserRuleCall_1_1_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }

		//stmts+=Stmt*
		public Assignment getStmtsAssignment_3() { return cStmtsAssignment_3; }

		//Stmt
		public RuleCall getStmtsStmtParserRuleCall_3_0() { return cStmtsStmtParserRuleCall_3_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
	}

	public class PortElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "Port");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Keyword cColonKeyword_0_0 = (Keyword)cGroup_0.eContents().get(0);
		private final Assignment cCompass_ptAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cCompass_ptCOMPASS_PTTerminalRuleCall_0_1_0 = (RuleCall)cCompass_ptAssignment_0_1.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cNameAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cNameIDParserRuleCall_1_1_0 = (RuleCall)cNameAssignment_1_1.eContents().get(0);
		private final Group cGroup_1_2 = (Group)cGroup_1.eContents().get(2);
		private final Keyword cColonKeyword_1_2_0 = (Keyword)cGroup_1_2.eContents().get(0);
		private final Assignment cCompass_ptAssignment_1_2_1 = (Assignment)cGroup_1_2.eContents().get(1);
		private final RuleCall cCompass_ptCOMPASS_PTTerminalRuleCall_1_2_1_0 = (RuleCall)cCompass_ptAssignment_1_2_1.eContents().get(0);
		
		//Port:
		//	":" compass_pt=COMPASS_PT | ":" name=ID (":" compass_pt=COMPASS_PT)?;
		public ParserRule getRule() { return rule; }

		//=> ":" compass_pt=COMPASS_PT | ":" name=ID (":" compass_pt=COMPASS_PT)?
		public Alternatives getAlternatives() { return cAlternatives; }

		//=> ":" compass_pt=COMPASS_PT
		public Group getGroup_0() { return cGroup_0; }

		//=> ":"
		public Keyword getColonKeyword_0_0() { return cColonKeyword_0_0; }

		//compass_pt=COMPASS_PT
		public Assignment getCompass_ptAssignment_0_1() { return cCompass_ptAssignment_0_1; }

		//COMPASS_PT
		public RuleCall getCompass_ptCOMPASS_PTTerminalRuleCall_0_1_0() { return cCompass_ptCOMPASS_PTTerminalRuleCall_0_1_0; }

		//":" name=ID (":" compass_pt=COMPASS_PT)?
		public Group getGroup_1() { return cGroup_1; }

		//":"
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }

		//name=ID
		public Assignment getNameAssignment_1_1() { return cNameAssignment_1_1; }

		//ID
		public RuleCall getNameIDParserRuleCall_1_1_0() { return cNameIDParserRuleCall_1_1_0; }

		//(":" compass_pt=COMPASS_PT)?
		public Group getGroup_1_2() { return cGroup_1_2; }

		//":"
		public Keyword getColonKeyword_1_2_0() { return cColonKeyword_1_2_0; }

		//compass_pt=COMPASS_PT
		public Assignment getCompass_ptAssignment_1_2_1() { return cCompass_ptAssignment_1_2_1; }

		//COMPASS_PT
		public RuleCall getCompass_ptCOMPASS_PTTerminalRuleCall_1_2_1_0() { return cCompass_ptCOMPASS_PTTerminalRuleCall_1_2_1_0; }
	}

	public class EdgeRhsElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EdgeRhs");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEdgeRhsNodeParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cEdgeRhsSubgraphParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//EdgeRhs:
		//	EdgeRhsNode | EdgeRhsSubgraph;
		public ParserRule getRule() { return rule; }

		//EdgeRhsNode | EdgeRhsSubgraph
		public Alternatives getAlternatives() { return cAlternatives; }

		//EdgeRhsNode
		public RuleCall getEdgeRhsNodeParserRuleCall_0() { return cEdgeRhsNodeParserRuleCall_0; }

		//EdgeRhsSubgraph
		public RuleCall getEdgeRhsSubgraphParserRuleCall_1() { return cEdgeRhsSubgraphParserRuleCall_1; }
	}

	public class EdgeRhsNodeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EdgeRhsNode");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOpAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOpEdgeOpEnumRuleCall_0_0 = (RuleCall)cOpAssignment_0.eContents().get(0);
		private final Assignment cNodeAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNodeNodeIdParserRuleCall_1_0 = (RuleCall)cNodeAssignment_1.eContents().get(0);
		
		//EdgeRhsNode:
		//	op=EdgeOp node=NodeId;
		public ParserRule getRule() { return rule; }

		//op=EdgeOp node=NodeId
		public Group getGroup() { return cGroup; }

		//op=EdgeOp
		public Assignment getOpAssignment_0() { return cOpAssignment_0; }

		//EdgeOp
		public RuleCall getOpEdgeOpEnumRuleCall_0_0() { return cOpEdgeOpEnumRuleCall_0_0; }

		//node=NodeId
		public Assignment getNodeAssignment_1() { return cNodeAssignment_1; }

		//NodeId
		public RuleCall getNodeNodeIdParserRuleCall_1_0() { return cNodeNodeIdParserRuleCall_1_0; }
	}

	public class EdgeRhsSubgraphElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EdgeRhsSubgraph");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOpAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOpEdgeOpEnumRuleCall_0_0 = (RuleCall)cOpAssignment_0.eContents().get(0);
		private final Assignment cSubgraphAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cSubgraphSubgraphParserRuleCall_1_0 = (RuleCall)cSubgraphAssignment_1.eContents().get(0);
		
		//EdgeRhsSubgraph:
		//	op=EdgeOp subgraph=Subgraph;
		public ParserRule getRule() { return rule; }

		//op=EdgeOp subgraph=Subgraph
		public Group getGroup() { return cGroup; }

		//op=EdgeOp
		public Assignment getOpAssignment_0() { return cOpAssignment_0; }

		//EdgeOp
		public RuleCall getOpEdgeOpEnumRuleCall_0_0() { return cOpEdgeOpEnumRuleCall_0_0; }

		//subgraph=Subgraph
		public Assignment getSubgraphAssignment_1() { return cSubgraphAssignment_1; }

		//Subgraph
		public RuleCall getSubgraphSubgraphParserRuleCall_1_0() { return cSubgraphSubgraphParserRuleCall_1_0; }
	}

	public class NodeIdElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NodeId");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameIDParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Assignment cPortAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cPortPortParserRuleCall_1_0 = (RuleCall)cPortAssignment_1.eContents().get(0);
		
		//NodeId:
		//	name=ID port=Port?;
		public ParserRule getRule() { return rule; }

		//name=ID port=Port?
		public Group getGroup() { return cGroup; }

		//name=ID
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//ID
		public RuleCall getNameIDParserRuleCall_0_0() { return cNameIDParserRuleCall_0_0; }

		//port=Port?
		public Assignment getPortAssignment_1() { return cPortAssignment_1; }

		//Port
		public RuleCall getPortPortParserRuleCall_1_0() { return cPortPortParserRuleCall_1_0; }
	}

	public class IDElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ID");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cSTRINGTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cQUOTED_STRINGTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cNUMERALTerminalRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cCOMPASS_PTTerminalRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//// XXX: While node, edge, graph, digraph, subgraph, and strict are keywords (and thus not allowed as part of an ID), compass point values are no keywords (and may thus be used as ID)
		//ID:
		//	STRING | QUOTED_STRING | NUMERAL | COMPASS_PT;
		public ParserRule getRule() { return rule; }

		//STRING | QUOTED_STRING | NUMERAL | COMPASS_PT
		public Alternatives getAlternatives() { return cAlternatives; }

		//STRING
		public RuleCall getSTRINGTerminalRuleCall_0() { return cSTRINGTerminalRuleCall_0; }

		//QUOTED_STRING
		public RuleCall getQUOTED_STRINGTerminalRuleCall_1() { return cQUOTED_STRINGTerminalRuleCall_1; }

		//NUMERAL
		public RuleCall getNUMERALTerminalRuleCall_2() { return cNUMERALTerminalRuleCall_2; }

		//COMPASS_PT
		public RuleCall getCOMPASS_PTTerminalRuleCall_3() { return cCOMPASS_PTTerminalRuleCall_3; }
	}
	
	
	public class EdgeOpElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "EdgeOp");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cDirectedEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cDirectedHyphenMinusGreaterThanSignKeyword_0_0 = (Keyword)cDirectedEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cUndirectedEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cUndirectedHyphenMinusHyphenMinusKeyword_1_0 = (Keyword)cUndirectedEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum EdgeOp:
		//	directed="->" | undirected="--";
		public EnumRule getRule() { return rule; }

		//directed="->" | undirected="--"
		public Alternatives getAlternatives() { return cAlternatives; }

		//directed="->"
		public EnumLiteralDeclaration getDirectedEnumLiteralDeclaration_0() { return cDirectedEnumLiteralDeclaration_0; }

		//"->"
		public Keyword getDirectedHyphenMinusGreaterThanSignKeyword_0_0() { return cDirectedHyphenMinusGreaterThanSignKeyword_0_0; }

		//undirected="--"
		public EnumLiteralDeclaration getUndirectedEnumLiteralDeclaration_1() { return cUndirectedEnumLiteralDeclaration_1; }

		//"--"
		public Keyword getUndirectedHyphenMinusHyphenMinusKeyword_1_0() { return cUndirectedHyphenMinusHyphenMinusKeyword_1_0; }
	}

	public class GraphTypeElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "GraphType");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cGraphEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cGraphGraphKeyword_0_0 = (Keyword)cGraphEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cDigraphEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cDigraphDigraphKeyword_1_0 = (Keyword)cDigraphEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum GraphType:
		//	graph | digraph;
		public EnumRule getRule() { return rule; }

		//graph | digraph
		public Alternatives getAlternatives() { return cAlternatives; }

		//graph
		public EnumLiteralDeclaration getGraphEnumLiteralDeclaration_0() { return cGraphEnumLiteralDeclaration_0; }

		//"graph"
		public Keyword getGraphGraphKeyword_0_0() { return cGraphGraphKeyword_0_0; }

		//digraph
		public EnumLiteralDeclaration getDigraphEnumLiteralDeclaration_1() { return cDigraphEnumLiteralDeclaration_1; }

		//"digraph"
		public Keyword getDigraphDigraphKeyword_1_0() { return cDigraphDigraphKeyword_1_0; }
	}

	public class AttributeTypeElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "AttributeType");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cGraphEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cGraphGraphKeyword_0_0 = (Keyword)cGraphEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cNodeEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cNodeNodeKeyword_1_0 = (Keyword)cNodeEnumLiteralDeclaration_1.eContents().get(0);
		private final EnumLiteralDeclaration cEdgeEnumLiteralDeclaration_2 = (EnumLiteralDeclaration)cAlternatives.eContents().get(2);
		private final Keyword cEdgeEdgeKeyword_2_0 = (Keyword)cEdgeEnumLiteralDeclaration_2.eContents().get(0);
		
		//enum AttributeType:
		//	graph | node | edge;
		public EnumRule getRule() { return rule; }

		//graph | node | edge
		public Alternatives getAlternatives() { return cAlternatives; }

		//graph
		public EnumLiteralDeclaration getGraphEnumLiteralDeclaration_0() { return cGraphEnumLiteralDeclaration_0; }

		//"graph"
		public Keyword getGraphGraphKeyword_0_0() { return cGraphGraphKeyword_0_0; }

		//node
		public EnumLiteralDeclaration getNodeEnumLiteralDeclaration_1() { return cNodeEnumLiteralDeclaration_1; }

		//"node"
		public Keyword getNodeNodeKeyword_1_0() { return cNodeNodeKeyword_1_0; }

		//edge
		public EnumLiteralDeclaration getEdgeEnumLiteralDeclaration_2() { return cEdgeEnumLiteralDeclaration_2; }

		//"edge"
		public Keyword getEdgeEdgeKeyword_2_0() { return cEdgeEdgeKeyword_2_0; }
	}
	
	private final DotAstElements pDotAst;
	private final DotGraphElements pDotGraph;
	private final StmtElements pStmt;
	private final EdgeStmtNodeElements pEdgeStmtNode;
	private final EdgeStmtSubgraphElements pEdgeStmtSubgraph;
	private final NodeStmtElements pNodeStmt;
	private final AttrStmtElements pAttrStmt;
	private final AttrListElements pAttrList;
	private final AttributeElements pAttribute;
	private final SubgraphOrEdgeStmtSubgraphElements pSubgraphOrEdgeStmtSubgraph;
	private final SubgraphElements pSubgraph;
	private final PortElements pPort;
	private final EdgeRhsElements pEdgeRhs;
	private final EdgeRhsNodeElements pEdgeRhsNode;
	private final EdgeRhsSubgraphElements pEdgeRhsSubgraph;
	private final NodeIdElements pNodeId;
	private final IDElements pID;
	private final EdgeOpElements unknownRuleEdgeOp;
	private final GraphTypeElements unknownRuleGraphType;
	private final AttributeTypeElements unknownRuleAttributeType;
	private final TerminalRule tCOMPASS_PT;
	private final TerminalRule tSTRING;
	private final TerminalRule tNUMERAL;
	private final TerminalRule tQUOTED_STRING;
	private final TerminalRule tML_COMMENT;
	private final TerminalRule tSL_COMMENT;
	private final TerminalRule tWS;
	private final TerminalRule tANY_OTHER;
	
	private final Grammar grammar;

	@Inject
	public DotGrammarAccess(GrammarProvider grammarProvider) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.pDotAst = new DotAstElements();
		this.pDotGraph = new DotGraphElements();
		this.pStmt = new StmtElements();
		this.pEdgeStmtNode = new EdgeStmtNodeElements();
		this.pEdgeStmtSubgraph = new EdgeStmtSubgraphElements();
		this.pNodeStmt = new NodeStmtElements();
		this.pAttrStmt = new AttrStmtElements();
		this.pAttrList = new AttrListElements();
		this.pAttribute = new AttributeElements();
		this.pSubgraphOrEdgeStmtSubgraph = new SubgraphOrEdgeStmtSubgraphElements();
		this.pSubgraph = new SubgraphElements();
		this.pPort = new PortElements();
		this.pEdgeRhs = new EdgeRhsElements();
		this.pEdgeRhsNode = new EdgeRhsNodeElements();
		this.pEdgeRhsSubgraph = new EdgeRhsSubgraphElements();
		this.pNodeId = new NodeIdElements();
		this.pID = new IDElements();
		this.unknownRuleEdgeOp = new EdgeOpElements();
		this.unknownRuleGraphType = new GraphTypeElements();
		this.unknownRuleAttributeType = new AttributeTypeElements();
		this.tCOMPASS_PT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "COMPASS_PT");
		this.tSTRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "STRING");
		this.tNUMERAL = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "NUMERAL");
		this.tQUOTED_STRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "QUOTED_STRING");
		this.tML_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ML_COMMENT");
		this.tSL_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "SL_COMMENT");
		this.tWS = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "WS");
		this.tANY_OTHER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ANY_OTHER");
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.gef4.dot.internal.parser.Dot".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	
	public Grammar getGrammar() {
		return grammar;
	}
	

	
	//DotAst:
	//	graphs+=DotGraph*;
	public DotAstElements getDotAstAccess() {
		return pDotAst;
	}
	
	public ParserRule getDotAstRule() {
		return getDotAstAccess().getRule();
	}

	//DotGraph:
	//	strict?="strict"? type=GraphType name=ID? "{" stmts+=Stmt* "}";
	public DotGraphElements getDotGraphAccess() {
		return pDotGraph;
	}
	
	public ParserRule getDotGraphRule() {
		return getDotGraphAccess().getRule();
	}

	//// XXX: We need to handle EdgeStmtSubgraph together with Subgraph, or the grammar would be ambiguous
	//Stmt:
	//	(NodeStmt | EdgeStmtNode | AttrStmt | Attribute | SubgraphOrEdgeStmtSubgraph) ";"?;
	public StmtElements getStmtAccess() {
		return pStmt;
	}
	
	public ParserRule getStmtRule() {
		return getStmtAccess().getRule();
	}

	//EdgeStmtNode:
	//	node=NodeId edgeRHS+=EdgeRhs+ attrLists+=AttrList*;
	public EdgeStmtNodeElements getEdgeStmtNodeAccess() {
		return pEdgeStmtNode;
	}
	
	public ParserRule getEdgeStmtNodeRule() {
		return getEdgeStmtNodeAccess().getRule();
	}

	//EdgeStmtSubgraph:
	//	subgraph=Subgraph edgeRHS+=EdgeRhs+ attrLists+=AttrList*;
	public EdgeStmtSubgraphElements getEdgeStmtSubgraphAccess() {
		return pEdgeStmtSubgraph;
	}
	
	public ParserRule getEdgeStmtSubgraphRule() {
		return getEdgeStmtSubgraphAccess().getRule();
	}

	//NodeStmt:
	//	node=NodeId attrLists+=AttrList*;
	public NodeStmtElements getNodeStmtAccess() {
		return pNodeStmt;
	}
	
	public ParserRule getNodeStmtRule() {
		return getNodeStmtAccess().getRule();
	}

	//AttrStmt:
	//	type=AttributeType attrLists+=AttrList+;
	public AttrStmtElements getAttrStmtAccess() {
		return pAttrStmt;
	}
	
	public ParserRule getAttrStmtRule() {
		return getAttrStmtAccess().getRule();
	}

	//AttrList:
	//	{AttrList} "[" (attributes+=Attribute ("," | ";")?)* "]";
	public AttrListElements getAttrListAccess() {
		return pAttrList;
	}
	
	public ParserRule getAttrListRule() {
		return getAttrListAccess().getRule();
	}

	//Attribute:
	//	name=ID "=" value=ID;
	public AttributeElements getAttributeAccess() {
		return pAttribute;
	}
	
	public ParserRule getAttributeRule() {
		return getAttributeAccess().getRule();
	}

	//// XXX: We perform an assign action, so the parse tree is rewritten in case a subgraph is specified through an EdgeStmt
	//SubgraphOrEdgeStmtSubgraph:
	//	Subgraph ({EdgeStmtSubgraph.subgraph=current} edgeRHS+=EdgeRhs+ attrLists+=AttrList*)?;
	public SubgraphOrEdgeStmtSubgraphElements getSubgraphOrEdgeStmtSubgraphAccess() {
		return pSubgraphOrEdgeStmtSubgraph;
	}
	
	public ParserRule getSubgraphOrEdgeStmtSubgraphRule() {
		return getSubgraphOrEdgeStmtSubgraphAccess().getRule();
	}

	//Subgraph:
	//	{Subgraph} ("subgraph" name=ID?)? "{" stmts+=Stmt* "}";
	public SubgraphElements getSubgraphAccess() {
		return pSubgraph;
	}
	
	public ParserRule getSubgraphRule() {
		return getSubgraphAccess().getRule();
	}

	//Port:
	//	":" compass_pt=COMPASS_PT | ":" name=ID (":" compass_pt=COMPASS_PT)?;
	public PortElements getPortAccess() {
		return pPort;
	}
	
	public ParserRule getPortRule() {
		return getPortAccess().getRule();
	}

	//EdgeRhs:
	//	EdgeRhsNode | EdgeRhsSubgraph;
	public EdgeRhsElements getEdgeRhsAccess() {
		return pEdgeRhs;
	}
	
	public ParserRule getEdgeRhsRule() {
		return getEdgeRhsAccess().getRule();
	}

	//EdgeRhsNode:
	//	op=EdgeOp node=NodeId;
	public EdgeRhsNodeElements getEdgeRhsNodeAccess() {
		return pEdgeRhsNode;
	}
	
	public ParserRule getEdgeRhsNodeRule() {
		return getEdgeRhsNodeAccess().getRule();
	}

	//EdgeRhsSubgraph:
	//	op=EdgeOp subgraph=Subgraph;
	public EdgeRhsSubgraphElements getEdgeRhsSubgraphAccess() {
		return pEdgeRhsSubgraph;
	}
	
	public ParserRule getEdgeRhsSubgraphRule() {
		return getEdgeRhsSubgraphAccess().getRule();
	}

	//NodeId:
	//	name=ID port=Port?;
	public NodeIdElements getNodeIdAccess() {
		return pNodeId;
	}
	
	public ParserRule getNodeIdRule() {
		return getNodeIdAccess().getRule();
	}

	//// XXX: While node, edge, graph, digraph, subgraph, and strict are keywords (and thus not allowed as part of an ID), compass point values are no keywords (and may thus be used as ID)
	//ID:
	//	STRING | QUOTED_STRING | NUMERAL | COMPASS_PT;
	public IDElements getIDAccess() {
		return pID;
	}
	
	public ParserRule getIDRule() {
		return getIDAccess().getRule();
	}

	//enum EdgeOp:
	//	directed="->" | undirected="--";
	public EdgeOpElements getEdgeOpAccess() {
		return unknownRuleEdgeOp;
	}
	
	public EnumRule getEdgeOpRule() {
		return getEdgeOpAccess().getRule();
	}

	//enum GraphType:
	//	graph | digraph;
	public GraphTypeElements getGraphTypeAccess() {
		return unknownRuleGraphType;
	}
	
	public EnumRule getGraphTypeRule() {
		return getGraphTypeAccess().getRule();
	}

	//enum AttributeType:
	//	graph | node | edge;
	public AttributeTypeElements getAttributeTypeAccess() {
		return unknownRuleAttributeType;
	}
	
	public EnumRule getAttributeTypeRule() {
		return getAttributeTypeAccess().getRule();
	}

	//// XXX: While keywords are case insensitive, compass point values are not; we thus parse them as terminals
	//terminal COMPASS_PT:
	//	"n" | "ne" | "e" | "se" | "s" | "sw" | "w" | "nw" | "c" | "_";
	public TerminalRule getCOMPASS_PTRule() {
		return tCOMPASS_PT;
	} 

	//// XXX: Any string of alphabetic ([a-zA-Z\200-\377]) characters, underscores ('_') or digits ([0-9]), not beginning with a digit;
	//terminal STRING:
	//	("a".."z" | "A".."Z" | "".."ÿ" | "_") ("a".."z" | "A".."Z" | "".."ÿ" | "_" | "0".."9")*;
	public TerminalRule getSTRINGRule() {
		return tSTRING;
	} 

	//terminal NUMERAL:
	//	"-"? ("." "0".."9"+) | "0".."9"+ ("." "0".."9"*)?;
	public TerminalRule getNUMERALRule() {
		return tNUMERAL;
	} 

	//terminal QUOTED_STRING:
	//	"\"" ("\\" "\"" | !"\"")* "\"";
	public TerminalRule getQUOTED_STRINGRule() {
		return tQUOTED_STRING;
	} 

	//terminal ML_COMMENT:
	//	"/ *"->"* /";
	public TerminalRule getML_COMMENTRule() {
		return tML_COMMENT;
	} 

	//terminal SL_COMMENT:
	//	("//" | "#") !("\n" | "\r")* ("\r"? "\n")?;
	public TerminalRule getSL_COMMENTRule() {
		return tSL_COMMENT;
	} 

	//terminal WS:
	//	(" " | "\t" | "\r" | "\n")+;
	public TerminalRule getWSRule() {
		return tWS;
	} 

	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return tANY_OTHER;
	} 
}
