/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.gef4.dot.internal.DotFileUtils;

public final class DotExecutableUtils {
    private DotExecutableUtils() {
    }

    public static File renderImage(File dotExecutablePath, File dotInputFile, String format, String outputFileName) {
        String dotFile = dotInputFile.getName();
        String resultFile = outputFileName == null ? String.valueOf(dotFile.substring(0, dotFile.lastIndexOf(46) + 1)) + format : outputFileName;
        String inputFolder = String.valueOf(new File(dotInputFile.getParent()).getAbsolutePath()) + File.separator;
        String outputFolder = outputFileName == null ? inputFolder : String.valueOf(new File(new File(outputFileName).getAbsolutePath()).getParentFile().getAbsolutePath()) + File.separator;
        File outputFile = new File(outputFolder, resultFile);
        String[] outputs = DotExecutableUtils.executeDot(dotExecutablePath, false, dotInputFile, outputFile, format);
        if (!outputs[0].isEmpty()) {
            System.out.println("Output from dot call: " + outputs[0]);
        }
        if (!outputs[1].isEmpty()) {
            System.err.println("Errors from dot call: " + outputs[1]);
        }
        return outputFile;
    }

    public static String[] executeDot(File dotExecutablePath, boolean invertYAxis, File dotInputFile, File outputFile, String outputFormat) {
        File buffer = null;
        boolean hasBuffer = false;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(dotExecutablePath.getAbsolutePath());
        if (invertYAxis) {
            commands.add("-y");
        }
        if (outputFormat != null) {
            commands.add("-T" + outputFormat);
        }
        if (outputFile != null) {
            buffer = outputFile;
        } else {
            try {
                buffer = File.createTempFile("tmpResult", ".dot");
                hasBuffer = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        commands.add("-o" + buffer.toPath().toString());
        commands.add(dotInputFile.toPath().toString());
        String[] call = DotExecutableUtils.call(commands.toArray(new String[0]));
        if (hasBuffer) {
            try {
                try {
                    FileInputStream input = new FileInputStream(buffer);
                    call[0] = DotExecutableUtils.read(input);
                    input.close();
                }
                catch (Exception exception) {
                    System.out.println("failed to read temp dot file");
                    buffer.delete();
                }
            }
            finally {
                buffer.delete();
            }
            return call;
        }
        return call;
    }

    public static String[] getSupportedExportFormats(String dotExecutable) {
        String[] commands = new String[]{dotExecutable, "-T?"};
        String[] outputs = DotExecutableUtils.call(commands);
        String output = outputs[1];
        if (!output.isEmpty()) {
            String supportedFormats = output.substring(output.lastIndexOf(": ") + 2);
            supportedFormats = supportedFormats.trim();
            return supportedFormats.split(" ");
        }
        return new String[0];
    }

    private static String[] call(String[] commands) {
        System.out.print("Calling '" + Arrays.asList(commands) + "'");
        String[] outputs = new String[]{"", ""};
        Runtime runtime = Runtime.getRuntime();
        Process p = null;
        try {
            p = runtime.exec(commands);
            p.waitFor();
            System.out.println(" resulted in exit status: " + p.exitValue() + ".");
        }
        catch (Exception e) {
            System.out.println(" failed with exception " + e.getMessage() + ".");
        }
        if (p != null) {
            String errors;
            String output;
            outputs[0] = output = DotExecutableUtils.read(p.getInputStream());
            outputs[1] = errors = DotExecutableUtils.read(p.getErrorStream());
        }
        return outputs;
    }

    private static String read(InputStream is) {
        try {
            return DotFileUtils.read(is).replaceAll("\\\\" + System.lineSeparator(), "").trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

