/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.utils;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Robot;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import org.eclipse.gef4.fx.FxBundle;
import org.eclipse.gef4.geometry.planar.Point;

public class CursorUtils {
    private static final String JAVA_AWT_HEADLESS_PROPERTY = "java.awt.headless";

    public static void forceCursorUpdate(Scene scene) {
        try {
            Field mouseHandlerField = scene.getClass().getDeclaredField("mouseHandler");
            mouseHandlerField.setAccessible(true);
            Object mouseHandler = mouseHandlerField.get(scene);
            Class<?> mouseHandlerClass = Class.forName("javafx.scene.Scene$MouseHandler");
            Method updateCursorMethod = mouseHandlerClass.getDeclaredMethod("updateCursor", Cursor.class);
            updateCursorMethod.setAccessible(true);
            updateCursorMethod.invoke(mouseHandler, scene.getCursor());
            Method updateCursorFrameMethod = mouseHandlerClass.getDeclaredMethod("updateCursorFrame", new Class[0]);
            updateCursorFrameMethod.setAccessible(true);
            updateCursorFrameMethod.invoke(mouseHandler, new Object[0]);
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
    }

    public static Point getPointerLocation() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS X") && FxBundle.getContext() == null) {
            Robot robot = Application.GetApplication().createRobot();
            return new Point((double)robot.getMouseX(), (double)robot.getMouseY());
        }
        String awtHeadlessPropertyValue = System.getProperty(JAVA_AWT_HEADLESS_PROPERTY);
        if (awtHeadlessPropertyValue != null && awtHeadlessPropertyValue != Boolean.FALSE.toString()) {
            System.setProperty(JAVA_AWT_HEADLESS_PROPERTY, Boolean.FALSE.toString());
        }
        PointerInfo pi = MouseInfo.getPointerInfo();
        java.awt.Point mp = pi.getLocation();
        if (awtHeadlessPropertyValue != null) {
            System.setProperty(JAVA_AWT_HEADLESS_PROPERTY, awtHeadlessPropertyValue);
        }
        return new Point((double)mp.x, (double)mp.y);
    }
}

