/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXHandlePart;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultSelectionFeedbackPartFactory;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultSelectionHandlePartFactory;

public abstract class AbstractFXSegmentHandlePart<N extends Node>
extends AbstractFXHandlePart<N>
implements Comparable<AbstractFXSegmentHandlePart<? extends Node>> {
    private Provider<BezierCurve[]> segmentsProvider;
    private BezierCurve[] segments;
    private int segmentIndex = -1;
    private double segmentParameter = 0.0;

    @Override
    public int compareTo(AbstractFXSegmentHandlePart<? extends Node> o) {
        if (!this.getAnchoragesUnmodifiable().equals((Object)o.getAnchoragesUnmodifiable())) {
            throw new IllegalArgumentException("Can only compare FXSegmentHandleParts that are bound to the same anchorages.");
        }
        return (int)((double)(100 * this.getSegmentIndex()) + 10.0 * this.getSegmentParameter() - ((double)(100 * o.getSegmentIndex()) + 10.0 * o.getSegmentParameter()));
    }

    public void doRefreshVisual(N visual) {
        this.updateLocation(visual);
    }

    protected BezierCurve getBezierSegmentInParent() {
        this.segments = (BezierCurve[])this.segmentsProvider.get();
        if (this.segmentIndex < 0 || this.segmentIndex > this.segments.length - 1) {
            return null;
        }
        return (BezierCurve)NodeUtils.sceneToLocal((Node)((Node)this.getVisual()).getParent(), (IGeometry)this.segments[this.segmentIndex]);
    }

    protected Color getConnectedFill() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"CONNECTED_HANDLE_COLOR_PROVIDER"));
        return connectedColorProvider == null ? FXDefaultSelectionHandlePartFactory.DEFAULT_CONNECTED_HANDLE_COLOR : (Color)connectedColorProvider.get();
    }

    protected Color getInsertFill() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"INSERT_HANDLE_COLOR_PROVIDER"));
        return connectedColorProvider == null ? FXDefaultSelectionHandlePartFactory.DEFAULT_INSERT_HANDLE_COLOR : (Color)connectedColorProvider.get();
    }

    protected Color getMoveFill() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"MOVE_HANDLE_COLOR_PROVIDER"));
        return connectedColorProvider == null ? FXDefaultSelectionHandlePartFactory.DEFAULT_MOVE_HANDLE_COLOR : (Color)connectedColorProvider.get();
    }

    protected Point getPosition(BezierCurve segment) {
        return segment.get(this.segmentParameter);
    }

    public int getSegmentCount() {
        return this.segments == null ? 0 : this.segments.length;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public double getSegmentParameter() {
        return this.segmentParameter;
    }

    protected BezierCurve[] getSegmentsInScene() {
        return this.segments;
    }

    protected Color getStroke() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"PRIMARY_SELECTION_FEEDBACK_COLOR_PROVIDER"));
        return connectedColorProvider == null ? FXDefaultSelectionFeedbackPartFactory.DEFAULT_PRIMARY_SELECTION_FEEDBACK_COLOR : (Color)connectedColorProvider.get();
    }

    public void setSegmentIndex(int segmentIndex) {
        int oldSegmentIndex = this.segmentIndex;
        this.segmentIndex = segmentIndex;
        if (oldSegmentIndex != segmentIndex) {
            this.refreshVisual();
        }
    }

    public void setSegmentParameter(double segmentParameter) {
        double oldSegmentParameter = this.segmentParameter;
        this.segmentParameter = segmentParameter;
        if (oldSegmentParameter != segmentParameter) {
            this.refreshVisual();
        }
    }

    public void setSegmentsProvider(Provider<BezierCurve[]> segmentsProvider) {
        this.segmentsProvider = segmentsProvider;
    }

    protected void updateLocation(N visual) {
        ObservableSetMultimap anchorages = this.getAnchoragesUnmodifiable();
        if (anchorages.keySet().size() < 1) {
            return;
        }
        BezierCurve segmentInParent = this.getBezierSegmentInParent();
        if (segmentInParent == null) {
            visual.setVisible(false);
        } else {
            visual.setVisible(true);
            Point positionInParent = this.getPosition(segmentInParent);
            visual.relocate(positionInParent.x + visual.getLayoutBounds().getMinX(), positionInParent.y + visual.getLayoutBounds().getMinY());
        }
    }
}

