/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXRootPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXRootPart
extends AbstractFXRootPart<Group> {
    public Group contentLayer;
    public Group handleLayer;
    public Group feedbackLayer;

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        if (child instanceof IContentPart) {
            int contentLayerIndex = 0;
            int i = 0;
            while (i < index) {
                if (i < this.getChildrenUnmodifiable().size() && this.getChildrenUnmodifiable().get(i) instanceof IContentPart) {
                    ++contentLayerIndex;
                }
                ++i;
            }
            this.getContentLayer().getChildren().add(contentLayerIndex, (Object)((Node)child.getVisual()));
        } else if (child instanceof IFeedbackPart) {
            int feedbackLayerIndex = 0;
            int i = 0;
            while (i < index) {
                if (i < this.getChildrenUnmodifiable().size() && this.getChildrenUnmodifiable().get(i) instanceof IFeedbackPart) {
                    ++feedbackLayerIndex;
                }
                ++i;
            }
            this.getFeedbackLayer().getChildren().add(feedbackLayerIndex, (Object)((Node)child.getVisual()));
        } else {
            int handleLayerIndex = 0;
            int i = 0;
            while (i < index) {
                if (i < this.getChildrenUnmodifiable().size() && this.getChildrenUnmodifiable().get(i) instanceof IHandlePart) {
                    ++handleLayerIndex;
                }
                ++i;
            }
            this.getHandleLayer().getChildren().add(handleLayerIndex, (Object)((Node)child.getVisual()));
        }
    }

    protected Group createContentLayer() {
        Group contentLayer = this.createLayer(false);
        contentLayer.setPickOnBounds(true);
        return contentLayer;
    }

    protected Group createFeedbackLayer() {
        return this.createLayer(true);
    }

    protected Group createHandleLayer() {
        return this.createLayer(false);
    }

    protected Group createLayer(boolean mouseTransparent) {
        Group layer = new Group();
        layer.setPickOnBounds(false);
        layer.setMouseTransparent(mouseTransparent);
        return layer;
    }

    protected Group createVisual() {
        this.contentLayer = this.createContentLayer();
        this.contentLayer.boundsInLocalProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            }
        });
        this.feedbackLayer = this.createFeedbackLayer();
        this.handleLayer = this.createHandleLayer();
        return new Group(new Node[]{this.contentLayer, this.feedbackLayer, this.handleLayer});
    }

    public void doRefreshVisual(Group visual) {
    }

    protected Group getContentLayer() {
        if (this.contentLayer == null) {
            this.createVisual();
        }
        return this.contentLayer;
    }

    protected Group getFeedbackLayer() {
        if (this.feedbackLayer == null) {
            this.createVisual();
        }
        return this.feedbackLayer;
    }

    protected Group getHandleLayer() {
        if (this.handleLayer == null) {
            this.createVisual();
        }
        return this.handleLayer;
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        if (child instanceof IContentPart) {
            this.getContentLayer().getChildren().remove(child.getVisual());
        } else if (child instanceof IFeedbackPart) {
            this.getFeedbackLayer().getChildren().remove(child.getVisual());
        } else {
            this.getHandleLayer().getChildren().remove(child.getVisual());
        }
    }
}

