/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.providers;

import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.fx.anchors.ChopBoxStrategy;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.IComputationStrategy;
import org.eclipse.gef4.fx.anchors.OrthogonalProjectionStrategy;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.providers.IAnchorProvider;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class DefaultAnchorProvider
extends IAdaptable.Bound.Impl<IVisualPart<Node, ? extends Node>>
implements IAnchorProvider {
    private DynamicAnchor defaultAnchor;
    private DynamicAnchor orthoAnchor;

    protected IGeometry computeAnchorageReferenceGeometry(DynamicAnchor anchor) {
        return NodeUtils.getShapeOutline((Node)((Node)((IVisualPart)this.getAdaptable()).getVisual()));
    }

    protected DynamicAnchor createDynamicAnchor(IComputationStrategy strategy) {
        DynamicAnchor anchor = new DynamicAnchor((Node)((IVisualPart)this.getAdaptable()).getVisual(), strategy);
        this.initializeComputationParameters(anchor);
        return anchor;
    }

    @Override
    public IAnchor get(IVisualPart<Node, ? extends Node> anchoredPart) {
        Connection connection;
        Node anchoredVisual = (Node)anchoredPart.getVisual();
        if (anchoredVisual instanceof Connection && (connection = (Connection)anchoredVisual).getRouter() instanceof OrthogonalRouter) {
            return this.getOrthogonalAnchor();
        }
        return this.getDefaultAnchor();
    }

    @Override
    public IAnchor get(IVisualPart<Node, ? extends Node> anchoredPart, String role) {
        return this.get(anchoredPart);
    }

    protected IAnchor getDefaultAnchor() {
        if (this.defaultAnchor == null) {
            this.defaultAnchor = this.createDynamicAnchor((IComputationStrategy)new ChopBoxStrategy());
        }
        return this.defaultAnchor;
    }

    protected IAnchor getOrthogonalAnchor() {
        if (this.orthoAnchor == null) {
            this.orthoAnchor = this.createDynamicAnchor((IComputationStrategy)new OrthogonalProjectionStrategy());
        }
        return this.orthoAnchor;
    }

    protected void initializeComputationParameters(final DynamicAnchor anchor) {
        ((DynamicAnchor.AnchorageReferenceGeometry)anchor.getComputationParameter(DynamicAnchor.AnchorageReferenceGeometry.class)).bind((ObservableValue)new ObjectBinding<IGeometry>(){
            {
                dynamicAnchor.anchorageProperty().addListener((ChangeListener)new ChangeListener<Node>(){

                    public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                        if (oldValue != null) {
                            this.unbind(new Observable[]{oldValue.layoutBoundsProperty()});
                        }
                        if (newValue != null) {
                            this.bind(new Observable[]{newValue.layoutBoundsProperty()});
                        }
                        this.invalidate();
                    }
                });
                this.bind(new Observable[]{dynamicAnchor.getAnchorage().layoutBoundsProperty()});
            }

            protected IGeometry computeValue() {
                return DefaultAnchorProvider.this.computeAnchorageReferenceGeometry(anchor);
            }
        });
    }
}

