/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class ChangeFocusOperation<VR>
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Change Focus";
    private IViewer<VR> viewer;
    private IContentPart<VR, ? extends VR> oldFocused;
    private IContentPart<VR, ? extends VR> newFocused;

    public ChangeFocusOperation(IViewer<VR> viewer, IContentPart<VR, ? extends VR> newFocused) {
        this(DEFAULT_LABEL, viewer, newFocused);
    }

    public ChangeFocusOperation(String label, IViewer<VR> viewer, IContentPart<VR, ? extends VR> newFocused) {
        super(label);
        this.viewer = viewer;
        this.oldFocused = this.getFocusModel().getFocus();
        this.newFocused = newFocused;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getFocusModel().setFocus(this.newFocused);
        return Status.OK_STATUS;
    }

    protected FocusModel<VR> getFocusModel() {
        FocusModel focusModel = (FocusModel)this.viewer.getAdapter(new TypeToken<FocusModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.viewer.getClass())));
        return focusModel;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return this.oldFocused == this.newFocused;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setNewFocused(IContentPart<VR, ? extends VR> newFocused) {
        this.newFocused = newFocused;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getFocusModel().setFocus(this.oldFocused);
        return Status.OK_STATUS;
    }
}

