/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.IPolicy;

public abstract class AbstractInteractionPolicy<VR>
extends AbstractPolicy<VR> {
    private final Map<IVisualPart<VR, ? extends VR>, Boolean> initialRefreshVisual = new HashMap<IVisualPart<VR, ? extends VR>, Boolean>();
    private Map<IPolicy<VR>, IDomain<VR>> domains = new HashMap<IPolicy<VR>, IDomain<VR>>();

    protected void commit(AbstractTransactionPolicy<VR> policy) {
        ITransactionalOperation o;
        if (policy != null && (o = policy.commit()) != null && !o.isNoOp()) {
            try {
                this.domains.remove(policy).execute(o, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                throw new RuntimeException("An exception occured when committing policy " + policy + ".", e);
            }
        }
    }

    protected void init(AbstractTransactionPolicy<VR> policy) {
        if (policy != null) {
            this.domains.put(policy, this.getHost().getRoot().getViewer().getDomain());
            policy.init();
        }
    }

    protected void restoreRefreshVisuals(IVisualPart<VR, ? extends VR> part) {
        part.setRefreshVisual(this.initialRefreshVisual.remove(part));
    }

    protected void rollback(AbstractTransactionPolicy<VR> policy) {
        if (policy != null) {
            this.domains.remove(policy);
            policy.rollback();
        }
    }

    protected void storeAndDisableRefreshVisuals(IVisualPart<VR, ? extends VR> part) {
        this.initialRefreshVisual.put(part, part.isRefreshVisual());
        part.setRefreshVisual(false);
    }
}

