/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.viewer;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdaptableSupport;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.InjectAdapters;
import org.eclipse.gef4.mvc.behaviors.ContentPartPool;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractViewer<VR>
implements IViewer<VR> {
    @Inject
    private ContentPartPool<VR> contentPartPool;
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private AdaptableSupport<IViewer<VR>> ads = new AdaptableSupport((IAdaptable)this);
    private Map<Object, IContentPart<VR, ? extends VR>> contentsToContentPartMap = new IdentityHashMap<Object, IContentPart<VR, ? extends VR>>();
    private Map<VR, IVisualPart<VR, ? extends VR>> visualsToVisualPartMap = new HashMap<VR, IVisualPart<VR, ? extends VR>>();
    private ReadOnlyObjectWrapper<IDomain<VR>> domainProperty = new ReadOnlyObjectWrapper();

    public void activate() {
        if (!this.acs.isActive()) {
            if (this.getDomain() == null) {
                throw new IllegalStateException("Domain has to be set before activation.");
            }
            this.acs.activate();
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IDomain<VR>> adaptableProperty() {
        return this.domainProperty.getReadOnlyProperty();
    }

    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.ads.adaptersProperty();
    }

    public void deactivate() {
        if (this.acs.isActive()) {
            if (this.getDomain() == null) {
                throw new IllegalStateException("Domain may not be unset before deactivation is completed.");
            }
            this.acs.deactivate();
        }
    }

    public void dispose() {
        this.ads.dispose();
        this.ads = null;
        for (IContentPart<VR, VR> cp : this.contentPartPool.getPooled()) {
            cp.dispose();
        }
        this.contentPartPool.clear();
        this.contentPartPool = null;
        if (!this.contentsToContentPartMap.isEmpty()) {
            throw new IllegalStateException("Content part map was not properly cleared!");
        }
        this.contentsToContentPartMap = null;
        if (!this.visualsToVisualPartMap.isEmpty()) {
            throw new IllegalStateException("Visual part map was not properly cleared!");
        }
        this.visualsToVisualPartMap = null;
        this.acs = null;
    }

    public IDomain<VR> getAdaptable() {
        return (IDomain)this.domainProperty.get();
    }

    public <T> T getAdapter(AdapterKey<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> AdapterKey<T> getAdapterKey(T adapter) {
        return this.ads.getAdapterKey(adapter);
    }

    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.ads.getAdapters();
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public Map<Object, IContentPart<VR, ? extends VR>> getContentPartMap() {
        return this.contentsToContentPartMap;
    }

    @Override
    public IDomain<VR> getDomain() {
        return (IDomain)this.domainProperty.get();
    }

    @Override
    public IRootPart<VR, ? extends VR> getRootPart() {
        return (IRootPart)this.ads.getAdapter(new TypeToken<IRootPart<VR, ? extends VR>>(this.getClass()){});
    }

    @Override
    public Map<VR, IVisualPart<VR, ? extends VR>> getVisualPartMap() {
        return this.visualsToVisualPartMap;
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    public void setAdaptable(IDomain<VR> domain) {
        this.domainProperty.set(domain);
    }

    public <T> void setAdapter(T adapter) {
        this.ads.setAdapter(adapter);
    }

    public <T> void setAdapter(T adapter, String role) {
        this.ads.setAdapter(adapter, role);
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.ads.setAdapter(adapterType, adapter);
    }

    @InjectAdapters
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        this.ads.setAdapter(adapterType, adapter, role);
    }

    public <T> void unsetAdapter(T adapter) {
        this.ads.unsetAdapter(adapter);
    }
}

