/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.attributes.IAttributeStore;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;

public class ChangeAttributeOperation
extends AbstractOperation
implements ITransactionalOperation {
    private IAttributeStore element;
    private String attributeKey;
    private Object newAttributeValue;
    private Object oldAttributeValue;

    public ChangeAttributeOperation(IAttributeStore attributeStore, String attributeKey, Object attributeValue) {
        super("Change attribute value");
        this.element = attributeStore;
        this.attributeKey = attributeKey;
        this.oldAttributeValue = attributeStore.attributesProperty().get((Object)attributeKey);
        this.newAttributeValue = attributeValue;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object currentValue = this.element.attributesProperty().get((Object)this.attributeKey);
        if (!(this.newAttributeValue == currentValue || this.newAttributeValue != null && this.newAttributeValue.equals(currentValue))) {
            this.element.attributesProperty().put((Object)this.attributeKey, this.newAttributeValue);
        }
        return Status.OK_STATUS;
    }

    public boolean isContentRelevant() {
        return true;
    }

    public boolean isNoOp() {
        return this.oldAttributeValue == this.newAttributeValue || this.oldAttributeValue != null && this.oldAttributeValue.equals(this.newAttributeValue);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object currentValue = this.element.attributesProperty().get((Object)this.attributeKey);
        if (!(this.oldAttributeValue == currentValue || this.oldAttributeValue != null && this.oldAttributeValue.equals(currentValue))) {
            this.element.attributesProperty().put((Object)this.attributeKey, this.oldAttributeValue);
        }
        return Status.OK_STATUS;
    }
}

