/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.impl.schema;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.json.IValidationReporter;
import org.eclipse.json.impl.schema.JSONSchemaNode;
import org.eclipse.json.impl.schema.JSONSchemaProperty;
import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.json.schema.IJSONSchemaProperty;
import org.eclipse.json.schema.JSONSchemaType;

public class JSONSchemaDocument
extends JSONSchemaNode
implements IJSONSchemaDocument {
    private static final String DEFINITIONS = "#/definitions/";
    private final Map<String, IJSONSchemaProperty> definitions = new HashMap<String, IJSONSchemaProperty>();

    public JSONSchemaDocument(Reader reader) throws IOException {
        super(JsonObject.readFrom(reader), null);
        this.addDefinitions(this.getJsonObject());
        this.resolveReferences();
    }

    private void resolveReferences() {
        this.resolveReference(this);
        for (IJSONSchemaProperty definition : this.definitions.values()) {
            this.resolveReference(definition);
        }
        Collection<IJSONSchemaProperty> props = this.getProperties().values();
        for (IJSONSchemaProperty property : props) {
            this.resolveReference(property);
        }
    }

    private void resolveReference(IJSONSchemaProperty node) {
        String ref;
        IJSONSchemaProperty property;
        String reference = node.getReference();
        if (reference != null && (property = this.definitions.get(ref = reference.substring(DEFINITIONS.length()))) != null) {
            for (IJSONSchemaProperty p : property.getProperties().values()) {
                node.addProperty(p);
            }
            Collection<IJSONSchemaProperty> props = property.getProperties().values();
            Iterator iterator = props.iterator();
            while (iterator.hasNext()) {
                IJSONSchemaProperty p = (IJSONSchemaProperty)iterator.next();
                this.resolveReference(p);
            }
        }
        Collection<IJSONSchemaProperty> props = node.getProperties().values();
        for (IJSONSchemaProperty p : props) {
            this.resolveReference(p);
        }
        List<String> references = node.getReferences();
        for (String ref2 : references) {
            String r = ref2.substring(DEFINITIONS.length());
            IJSONSchemaProperty property2 = this.definitions.get(r);
            if (property2 == null) continue;
            for (IJSONSchemaProperty p : property2.getProperties().values()) {
                node.addProperty(p);
            }
        }
    }

    private void addDefinitions(JsonObject json) {
        JsonObject.Member member2 = null;
        JsonObject definitions = (JsonObject)json.get("definitions");
        if (definitions != null) {
            for (JsonObject.Member member2 : definitions) {
                this.addDefinition(new JSONSchemaProperty(member2.getName(), (JsonObject)member2.getValue(), this));
            }
        }
    }

    private void addDefinition(IJSONSchemaProperty property) {
        this.definitions.put(property.getName(), property);
    }

    @Override
    public IJSONSchemaProperty getProperty(IJSONPath path) {
        if (path == null || path.getSegments() == null || path.getSegments().length <= 0) {
            return this;
        }
        String[] segments = path.getSegments();
        String segment = segments[0];
        if (segment == null) {
            return null;
        }
        IJSONSchemaProperty property = this.getProperties().get(segment);
        if (property != null) {
            return this.getProperty(property, segments, 1);
        }
        return null;
    }

    private IJSONSchemaProperty getProperty(IJSONSchemaProperty node, String[] segments, int level) {
        if (segments.length < level + 1) {
            return node;
        }
        String segment = segments[level];
        Collection<IJSONSchemaProperty> props = node.getProperties().values();
        for (IJSONSchemaProperty property : props) {
            if (!segment.equals(property.getName())) continue;
            return this.getProperty(property, segments, level + 1);
        }
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public JSONSchemaType[] getType() {
        return null;
    }

    @Override
    public JSONSchemaType getFirstType() {
        return null;
    }

    public void validate(JsonValue value, IValidationReporter reporter) {
    }

    @Override
    public List<String> getEnumList() {
        return null;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }
}

