/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.impl.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.json.impl.schema.JSONSchemaProperty;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonArray;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.IJSONSchemaNode;
import org.eclipse.json.schema.IJSONSchemaProperty;

public class JSONSchemaNode
extends JsonObject
implements IJSONSchemaNode {
    private static final String PROPERTIES = "properties";
    private static final String REF = "$ref";
    private final IJSONSchemaNode parent;
    private final Map<String, IJSONSchemaProperty> properties;
    private final String reference;
    private final List<String> references;
    private JsonObject jsonObject;

    public JSONSchemaNode(JsonObject jsonObject, IJSONSchemaNode parent) {
        this.parent = parent;
        this.jsonObject = jsonObject;
        this.properties = new HashMap<String, IJSONSchemaProperty>();
        this.references = new ArrayList<String>();
        this.reference = jsonObject.getString(REF, null);
        this.walk(jsonObject, this, true);
    }

    private void add(JsonObject jsonObject, IJSONSchemaNode schemaNode, String pref) {
        JsonValue values = jsonObject.get(pref);
        if (values instanceof JsonArray) {
            JsonArray array = (JsonArray)values;
            for (JsonValue value : array) {
                if (value == null) continue;
                String ref = value.asObject().getString(REF, null);
                if (ref != null) {
                    this.references.add(ref);
                    continue;
                }
                this.walk(value.asObject(), schemaNode, true);
            }
        }
    }

    private void walk(JsonObject json, IJSONSchemaNode schemaNode, boolean add) {
        JsonObject items;
        JsonObject properties = (JsonObject)json.get(PROPERTIES);
        this.addProperties(schemaNode, properties, add);
        if (properties == null && (items = (JsonObject)json.get("items")) != null) {
            properties = (JsonObject)items.get(PROPERTIES);
            this.addProperties(schemaNode, properties, add);
            String ref = items.getString(REF, null);
            if (ref != null) {
                if (add) {
                    schemaNode.getReferences().add(ref);
                } else {
                    schemaNode.getReferences().remove(ref);
                }
            } else {
                this.walk(items, schemaNode, add);
            }
        }
        this.add(json, schemaNode, "allOf");
        this.add(json, schemaNode, "anyOf");
        this.add(json, schemaNode, "oneOf");
        JsonValue notMember = json.get("not");
        if (notMember != null) {
            this.walk(notMember.asObject(), schemaNode, false);
        }
    }

    private void addProperties(IJSONSchemaNode schemaNode, JsonObject properties, boolean add) {
        if (properties == null) {
            return;
        }
        for (JsonObject.Member member : properties) {
            if (add) {
                schemaNode.addProperty(new JSONSchemaProperty(member.getName(), (JsonObject)member.getValue(), schemaNode));
                continue;
            }
            schemaNode.getProperties().remove(member.getName());
        }
    }

    @Override
    public void addProperty(IJSONSchemaProperty property) {
        this.properties.put(property.getName(), property);
    }

    @Override
    public IJSONSchemaNode getParent() {
        return this.parent;
    }

    @Override
    public IJSONSchemaProperty[] getPropertyValues() {
        return this.properties.values().toArray(IJSONSchemaProperty.EMPTY_PROPERTY);
    }

    @Override
    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    @Override
    public void setJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public List<String> getReferences() {
        return this.references;
    }

    @Override
    public Map<String, IJSONSchemaProperty> getProperties() {
        return this.properties;
    }
}

