/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter;

import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.schema.Aut;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.archive.schema.UsedToolkit;

public class MobileToolkitIdConverter
extends AbstractXmlConverter {
    private static final int HIGHEST_META_DATA_VERSION_NUMBER = 6;
    private static final String OLD_TOOLKIT_ID = "ui.toolkit.MobileToolkitPlugin";
    private static final String NEW_TOOLKIT_ID = "ui.toolkit.mobile.IOSToolkitPlugin";

    @Override
    protected boolean conversionIsNecessary(Project xml) {
        return xml.getMetaDataVersion() <= 6;
    }

    @Override
    protected void convertImpl(Project xml) {
        if (xml.getAutToolKit().equals(OLD_TOOLKIT_ID)) {
            xml.setAutToolKit(NEW_TOOLKIT_ID);
        }
        for (Aut aut : xml.getAutList()) {
            if (!aut.getAutToolkit().equals(OLD_TOOLKIT_ID)) continue;
            aut.setAutToolkit(NEW_TOOLKIT_ID);
        }
        for (UsedToolkit usedToolkit : xml.getUsedToolkitList()) {
            if (!usedToolkit.getName().equals(OLD_TOOLKIT_ID)) continue;
            usedToolkit.setName(NEW_TOOLKIT_ID);
        }
    }
}

