/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.cmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jubula.client.cmd.JobConfiguration;
import org.eclipse.jubula.client.cmd.exceptions.PreValidateException;
import org.eclipse.jubula.client.cmd.i18n.Messages;
import org.eclipse.jubula.client.cmd.progess.HeadlessProgressProvider;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.errorhandling.IErrorMessagePresenter;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.Message;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.jubula.version.Vn;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmdlineClient
implements IProgressConsole {
    protected static final int EXIT_CODE_ERROR = 1;
    protected static final int EXIT_CODE_OK = 0;
    protected static final String OPT_NO_VAL = Messages.NoArgumentFor;
    protected static final String OPT_UNKNOWN = Messages.UnrecognizedOption;
    protected static final String JDBC_UNKNOWN = Messages.UnsupportedJDBC;
    private static Logger log = LoggerFactory.getLogger(AbstractCmdlineClient.class);
    private static boolean quiet = false;
    private static boolean errorOccured = false;
    private static boolean validationErrorOccured = false;
    private static boolean missingArgErrorOccured = false;
    private static boolean noRunValue = false;
    private CommandLine m_cmd = null;
    private File m_configFile;
    private JobConfiguration m_job;

    protected static Option createOption(String name, boolean hasArg, String argname, String text, boolean isReq) {
        Option opt = new Option(name, hasArg, text);
        opt.setRequired(isReq);
        opt.setArgName(argname);
        return opt;
    }

    protected void shutdown() {
        block10: {
            IAUTConfigPO startedConfig;
            try {
                if (!AutAgentConnection.getInstance().isConnected()) {
                    AbstractCmdlineClient.printlnConsoleError(Messages.ConnectionToAutUnexpectedly);
                }
            }
            catch (ConnectionException e) {
                log.info(Messages.ConnectionToAutUnexpectedly, (Throwable)e);
            }
            if ((startedConfig = this.m_job.getAutConfig()) == null) break block10;
            try {
                AutIdentifier startedAutId = new AutIdentifier((String)startedConfig.getConfigMap().get("AUT_ID"));
                if (AutAgentConnection.getInstance().isConnected()) {
                    ClientTest.instance().stopAut(startedAutId);
                }
            }
            catch (ConnectionException e) {
                log.info(Messages.ErrorWhileShuttingDownStopping, (Throwable)e);
            }
        }
        try {
            while (AutAgentConnection.getInstance().isConnected()) {
                ClientTest.instance().disconnectFromAutAgent();
                TimeUtil.delay((long)200L);
            }
        }
        catch (ConnectionException e) {
            log.info(Messages.ErrorWhileShuttingDownDisconnecting, (Throwable)e);
        }
        if (LockManager.isRunning()) {
            LockManager.instance().dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseCommandLine(String[] args) throws FileNotFoundException, ParseException, IOException {
        block12: {
            String[] cloneArgs = (String[])args.clone();
            Options options = this.createOptions(false);
            BasicParser parser = new BasicParser();
            try {
                int maxTrys = 5;
                Boolean parseNotOK = true;
                while (parseNotOK.booleanValue()) {
                    try {
                        this.m_cmd = parser.parse(options, cloneArgs);
                        parseNotOK = false;
                    }
                    catch (ParseException exp) {
                        if (maxTrys-- < 0) {
                            cloneArgs = this.handleParseException(args, exp, true);
                            throw new ParseException("");
                        }
                        cloneArgs = this.handleParseException(args, exp, false);
                    }
                }
                if (!this.m_cmd.hasOption("h")) break block12;
                this.printUsage();
                return false;
            }
            catch (PreValidateException exp) {
                String message = exp.getLocalizedMessage();
                if (message != null && message.length() > 0) {
                    AbstractCmdlineClient.printlnConsoleError(message);
                }
                this.printUsage();
                throw new ParseException("");
            }
        }
        if (this.m_cmd.hasOption("c")) {
            this.m_configFile = new File(this.m_cmd.getOptionValue("c"));
            if (!this.m_configFile.exists() || !this.m_configFile.canRead()) throw new FileNotFoundException("");
            AbstractCmdlineClient.printConsoleLn(String.valueOf(Messages.ClientConfigFile) + this.m_configFile.getAbsolutePath(), true);
            this.m_job = JobConfiguration.initJob(this.m_configFile);
        } else {
            this.m_job = JobConfiguration.initJob(null);
        }
        if (this.m_cmd.hasOption("q")) {
            quiet = true;
        }
        if (this.m_cmd.hasOption("n") || !StringUtils.isEmpty((String)this.m_job.getNoRunOptMode())) {
            noRunValue = true;
        }
        this.m_job.parseJobOptions(this.m_cmd);
        this.preValidate(this.m_job);
        return true;
    }

    private Options createOptions(boolean req) {
        Options options = new Options();
        options.addOption(AbstractCmdlineClient.createOption("h", false, "", Messages.ClientHelpOpt, false));
        options.addOption(AbstractCmdlineClient.createOption("q", false, "", Messages.ClientQuietOpt, false));
        options.addOption(AbstractCmdlineClient.createOption("c", true, "configfile", Messages.ClientConfigOpt, false));
        OptionGroup ogConnection = new OptionGroup();
        ogConnection.addOption(AbstractCmdlineClient.createOption("dburl", true, "database", Messages.ClientDburlOpt, false));
        ogConnection.addOption(AbstractCmdlineClient.createOption("dbscheme", true, "scheme", Messages.ClientDbschemeOpt, false));
        options.addOptionGroup(ogConnection);
        options.addOption(AbstractCmdlineClient.createOption("dbuser", true, "user", Messages.ClientDbuserOpt, false));
        options.addOption(AbstractCmdlineClient.createOption("dbpw", true, "password", Messages.ClientDbpwOpt, false));
        this.extendOptions(options, req);
        return options;
    }

    protected abstract void extendOptions(Options var1, boolean var2);

    protected void preRun() {
    }

    public static void printConsoleLn(String text, boolean printTimestamp) {
        String textToPrint = StringUtils.chomp((String)text);
        String consoleOutput = "";
        if (printTimestamp) {
            String timeStamp = DateFormat.getDateTimeInstance(3, 2).format(Calendar.getInstance().getTime());
            consoleOutput = NLS.bind((String)Messages.ClientCmdOutputWithTimeStamp, (Object)timeStamp, (Object)textToPrint);
        } else {
            consoleOutput = NLS.bind((String)Messages.ClientCmdOutputWithoutTimeStamp, (Object)textToPrint);
        }
        AbstractCmdlineClient.printConsole(consoleOutput);
    }

    public void writeErrorLine(String line) {
        AbstractCmdlineClient.printlnConsoleError(line);
    }

    public void writeLine(String line) {
        AbstractCmdlineClient.printConsole(String.valueOf(line) + "\n");
    }

    public void writeStatus(IStatus status) {
        AbstractCmdlineClient.printConsoleLn("AUT " + StringHelper.getStringOf((IStatus)status, (boolean)false) + "..." + "\n", true);
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus s = iStatusArray[n2];
                AbstractCmdlineClient.printConsoleLn("AUT " + StringHelper.getStringOf((IStatus)s, (boolean)false) + "..." + "\n", true);
                ++n2;
            }
        }
    }

    public void writeStatus(IStatus status, String id) {
        this.writeStatus(status);
    }

    public void closeConsole() {
    }

    public static void printConsole(String text) {
        if (!quiet) {
            System.out.print(text);
        }
    }

    public static void printlnConsoleError(String text) {
        errorOccured = true;
        log.error(String.valueOf(Messages.AnErrorOcurred) + ":" + " " + text);
        System.err.println(String.valueOf(Messages.ClientError) + "\n" + "\t" + text);
    }

    public int run(String[] args) {
        Job.getJobManager().setProgressProvider((ProgressProvider)new HeadlessProgressProvider());
        ErrorMessagePresenter.setPresenter((IErrorMessagePresenter)new IErrorMessagePresenter(){

            public void showErrorMessage(JBException ex, Object[] params, String[] details) {
                log.error(ex + ":" + " " + ex.getMessage());
                Integer messageID = ex.getErrorId();
                this.showErrorMessage(messageID, params, details);
            }

            public void showErrorMessage(Integer messageID, Object[] params, String[] details) {
                Message m = MessageIDs.getMessageObject((Integer)messageID);
                if (m == null) {
                    log.error(String.valueOf(Messages.NoCorrespondingMessage) + ":" + " " + messageID);
                } else {
                    String msgString = m.getMessage(params);
                    if (m.getSeverity() == 4) {
                        AbstractCmdlineClient.printlnConsoleError(msgString);
                    } else {
                        AbstractCmdlineClient.printConsole(msgString);
                    }
                }
            }
        });
        try {
            if (!this.parseCommandLine(args)) {
                return 0;
            }
        }
        catch (ParseException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return 1;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return 1;
        }
        this.preRun();
        try {
            int exitCode = this.doRun();
            if (AbstractCmdlineClient.isErrorOccured()) {
                exitCode = 1;
            }
            AbstractCmdlineClient.printConsoleLn(String.valueOf(Messages.ClientExitCode) + exitCode, true);
            return exitCode;
        }
        catch (Throwable t) {
            log.error(t.getLocalizedMessage(), t);
            AbstractCmdlineClient.printlnConsoleError(t.getLocalizedMessage());
            return 1;
        }
    }

    protected abstract int doRun();

    private void preValidate(JobConfiguration job) throws PreValidateException {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(Messages.ClientMissingArgs);
        StringBuilder errorInvalidArgsMsg = new StringBuilder();
        errorInvalidArgsMsg.append(Messages.ClientInvalidArgs);
        if (job.getDbConnectionName() == null && job.getDb() == null) {
            this.appendError(errorMsg, "dbscheme", "scheme OR");
            this.appendError(errorMsg, "dburl", "database");
        }
        if (!(job.getDb() == null || job.getDb().startsWith("jdbc:oracle:thin:@") || job.getDb().startsWith("jdbc:mysql://") || job.getDb().startsWith("jdbc:postgresql://") || job.getDb().startsWith("jdbc:h2:"))) {
            this.appendError(errorMsg, JDBC_UNKNOWN, job.getDb());
        }
        if (job.getDbuser() == null) {
            this.appendError(errorMsg, "dbuser", "user");
        }
        if (job.getDbpw() == null) {
            this.appendError(errorMsg, "dbpw", "password");
        }
        this.extendValidate(job, errorMsg, errorInvalidArgsMsg);
        if (missingArgErrorOccured) {
            errorMsg.append(Messages.ClientReadUserManual);
            throw new PreValidateException(errorMsg.toString());
        }
        if (job.getNoRunOptMode() != null && job.getTestJobName() != null) {
            throw new PreValidateException(String.valueOf(Messages.NoRunOptionDoesNotSupportTestJobs) + " " + Messages.ClientReadUserManual);
        }
        if (job.getDataDir() == String.valueOf(-2)) {
            throw new PreValidateException(Messages.NoPlatformInstanceLocation);
        }
        if (validationErrorOccured) {
            errorInvalidArgsMsg.append(Messages.ClientReadUserManual);
            throw new PreValidateException(errorInvalidArgsMsg.toString());
        }
        if (job.getDbscheme() == null && job.getDb() == null) {
            List availableConnections = DatabaseConnectionConverter.computeAvailableConnections();
            ArrayList<String> connectionNames = new ArrayList<String>();
            for (DatabaseConnection conn : availableConnections) {
                connectionNames.add(conn.getName());
            }
            throw new PreValidateException(NLS.bind((String)Messages.NoSuchDatabaseConnection, (Object[])new String[]{job.getDbConnectionName(), StringUtils.join(connectionNames, (String)", ")}));
        }
    }

    protected abstract void extendValidate(JobConfiguration var1, StringBuilder var2, StringBuilder var3);

    public String[] handleParseException(String[] args, ParseException exp, boolean printToConsole) {
        String message = exp.getLocalizedMessage();
        if (message != null && message.length() > 0 && printToConsole) {
            AbstractCmdlineClient.printlnConsoleError(this.extendMissingArgumentExceptionMessage(message, exp));
            this.printUsage();
        }
        if (message.startsWith(OPT_NO_VAL)) {
            message = this.printAndGetEndOfMessage(message, 1);
        } else if (message.startsWith(OPT_UNKNOWN)) {
            message = this.printAndGetEndOfMessage(message, 2);
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].endsWith(message)) {
                args[i] = "";
            }
            ++i;
        }
        return args;
    }

    private String extendMissingArgumentExceptionMessage(String errorMessage, ParseException exp) {
        Option option;
        MissingArgumentException missingArgExp;
        if (exp instanceof MissingArgumentException && (missingArgExp = (MissingArgumentException)exp) != null && (option = missingArgExp.getOption()) != null && option.getArgName() != null) {
            StringBuilder errorBuilder = new StringBuilder();
            this.appendError(errorBuilder, errorMessage, option.getArgName());
            errorBuilder.append(Messages.ClientReadUserManual);
            return errorBuilder.toString();
        }
        return errorMessage;
    }

    private String printAndGetEndOfMessage(String message, int indexForSubstring) {
        AbstractCmdlineClient.printlnConsoleError(message);
        int idx = message.indexOf(":");
        String substring = message.substring(idx + indexForSubstring);
        return substring;
    }

    protected void appendError(StringBuilder errorMsg, String msg1, String msg2) {
        missingArgErrorOccured = true;
        errorOccured = true;
        errorMsg.append("\t");
        errorMsg.append("-");
        errorMsg.append(msg1);
        errorMsg.append(" ");
        errorMsg.append(msg2);
        errorMsg.append("\n");
    }

    protected void appendValidationError(StringBuilder validationErrorMsg, String msg1, String msg2) {
        validationErrorOccured = true;
        errorOccured = true;
        validationErrorMsg.append("\t");
        validationErrorMsg.append("-");
        validationErrorMsg.append(msg1);
        validationErrorMsg.append(" ");
        validationErrorMsg.append(msg2);
        validationErrorMsg.append("\n");
    }

    private void printUsage() {
        this.writeLine(Vn.getDefault().getVersion().toString());
        Options options = this.createOptions(true);
        options.addOption(AbstractCmdlineClient.createOption("data", true, "workspace_location", Messages.ClientWorkspaceOpt, false));
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getCmdlineClientExecName(), options, true);
    }

    public abstract String getCmdlineClientExecName();

    public static boolean isNoRun() {
        return noRunValue;
    }

    public boolean isQuiet() {
        return quiet;
    }

    public static boolean isErrorOccured() {
        return errorOccured;
    }

    public static boolean isValidationErrorOccured() {
        return validationErrorOccured;
    }

    public static boolean isMissingArgErrorOccured() {
        return missingArgErrorOccured;
    }

    public CommandLine getCmdLine() {
        return this.m_cmd;
    }

    public JobConfiguration getJob() {
        return this.m_job;
    }

    public void writeWarningLine(String line) {
        this.writeLine(line);
    }
}

