/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.AbstractComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;

public class TestCaseComponentNameMapper
extends AbstractComponentNameMapper {
    public TestCaseComponentNameMapper(IWritableComponentNameCache componentNameCache, ISpecTestCasePO specTestCase) {
        super(componentNameCache, specTestCase);
    }

    @Override
    protected ISpecTestCasePO getContext() {
        return (ISpecTestCasePO)super.getContext();
    }

    @Override
    public void handleExistingNames(Map<String, String> guidToCompNameMap) {
        Iterator<INodePO> iter = this.getContext().getNodeListIterator();
        while (iter.hasNext()) {
            ICapPO capPO;
            INodePO o = iter.next();
            if (o instanceof IExecTestCasePO) {
                IExecTestCasePO execTestCase = (IExecTestCasePO)o;
                for (ICompNamesPairPO pair : execTestCase.getCompNamesPairs()) {
                    if (!guidToCompNameMap.containsKey(pair.getSecondName())) continue;
                    pair.setSecondName(guidToCompNameMap.get(pair.getSecondName()));
                }
            }
            if (!(o instanceof ICapPO) || !guidToCompNameMap.containsKey((capPO = (ICapPO)o).getComponentName())) continue;
            capPO.setComponentName(guidToCompNameMap.get(capPO.getComponentName()));
        }
    }

    @Override
    public Set<String> getUsedTypes(String compNameGuid) {
        Long currentProjectId = GeneralStorage.getInstance().getProject().getId();
        HashSet<String> typeSet = new HashSet<String>();
        HashSet<Long> namePairIds = new HashSet<Long>();
        HashSet<Long> capIds = new HashSet<Long>();
        Iterator<INodePO> iter = this.getContext().getNodeListIterator();
        while (iter.hasNext()) {
            INodePO o = iter.next();
            if (o instanceof IExecTestCasePO) {
                IExecTestCasePO execTestCase = (IExecTestCasePO)o;
                for (ICompNamesPairPO pair : execTestCase.getCompNamesPairs()) {
                    if (pair.getId() != null) {
                        namePairIds.add(pair.getId());
                    }
                    if (!compNameGuid.equals(pair.getSecondName())) continue;
                    CompNamesBP.searchCompType(pair, execTestCase);
                    typeSet.add(pair.getType());
                }
            }
            if (!(o instanceof ICapPO)) continue;
            ICapPO capPO = (ICapPO)o;
            if (capPO.getId() != null) {
                capIds.add(capPO.getId());
            }
            if (!compNameGuid.equals(capPO.getComponentName())) continue;
            typeSet.add(capPO.getComponentType());
        }
        typeSet.addAll(CompNamePM.getReuseTypes(GeneralStorage.getInstance().getMasterSession(), currentProjectId, compNameGuid, namePairIds, capIds, new HashSet<Long>()));
        return typeSet;
    }
}

