/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence.locking;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.ApplicationPO;
import org.eclipse.jubula.client.core.persistence.locking.DbGuardPO;
import org.eclipse.jubula.client.core.persistence.locking.DbLockPO;
import org.eclipse.jubula.tools.internal.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LockManager {
    private static final Long DB_GUARD_ID = 1L;
    private static final int UPDATE_TIMESTAMP_SECS = 60;
    private static final int TIMEOUT_APPLICATION = 180;
    private static Logger log = LoggerFactory.getLogger(LockManager.class);
    private static LockManager instance = null;
    private DbGuardPO m_dbGuard;
    private ApplicationPO m_application;
    private Thread m_keepAliveThread;
    private boolean m_keepRunning = true;

    private LockManager() {
        this.initDbObjects();
    }

    private void initDbObjects() {
        EntityManager sess = null;
        try {
            try {
                sess = Persistor.instance().openSession();
                EntityTransaction tx = sess.getTransaction();
                tx.begin();
                this.m_dbGuard = (DbGuardPO)sess.find(DbGuardPO.class, (Object)DB_GUARD_ID);
                this.m_application = new ApplicationPO(Long.MIN_VALUE);
                sess.persist((Object)this.m_application);
                tx.commit();
            }
            catch (PersistenceException e) {
                throw new JBFatalAbortException(Messages.LockingWontStart, (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(sess);
        }
        this.updateTimestamp();
    }

    private synchronized Result runInSession(DBRunnable action) {
        EntityManager sess = null;
        EntityTransaction tx = null;
        Result result = Result.FAILED;
        try {
            try {
                sess = Persistor.instance().openSession();
                tx = sess.getTransaction();
                tx.begin();
                this.lockDB(sess);
                result = action.run(sess);
                tx.commit();
                tx = null;
            }
            catch (PersistenceException e) {
                log.error(Messages.FailedToUpdateApplicationTimestamp, (Throwable)e);
                if (tx != null) {
                    tx.rollback();
                }
                Persistor.instance().dropSessionWithoutLockRelease(sess);
            }
        }
        finally {
            if (tx != null) {
                tx.rollback();
            }
            Persistor.instance().dropSessionWithoutLockRelease(sess);
        }
        return result;
    }

    public static LockManager instance() {
        if (instance == null) {
            instance = new LockManager();
        }
        return instance;
    }

    void updateTimestamp() {
        if (LockManager.isRunning() && this.m_application != null) {
            this.runInSession(new DBRunnable(){

                @Override
                public Result run(EntityManager sess) {
                    Query q = sess.createQuery("update ApplicationPO app set app.timestamp = CURRENT_TIMESTAMP where app.id = :id");
                    q.setParameter("id", (Object)LockManager.this.m_application.getId());
                    if (q.executeUpdate() != 1) {
                        log.error(Messages.UpdateOfTimestampFailed);
                    }
                    return Result.OK;
                }
            });
            this.runInSession(new DBRunnable(){

                @Override
                public Result run(EntityManager sess) {
                    sess.detach((Object)LockManager.this.m_application);
                    LockManager.this.m_application = (ApplicationPO)sess.find(ApplicationPO.class, (Object)LockManager.this.m_application.getId());
                    return Result.OK;
                }
            });
        }
    }

    void checkForTimeouts() {
        if (LockManager.isRunning() && this.m_application != null) {
            this.runInSession(new DBRunnable(){

                @Override
                public Result run(EntityManager sess) {
                    Query deadQuery = sess.createQuery("select app from ApplicationPO app where app.timestamp < :deadTime");
                    Date deadTime = new Date(LockManager.this.m_application.getTimestamp().getTime() - 180000L);
                    deadQuery.setParameter("deadTime", deadTime, TemporalType.TIMESTAMP);
                    List deadApps = deadQuery.getResultList();
                    for (ApplicationPO appl : deadApps) {
                        LockManager.this.removeApp(sess, appl);
                    }
                    return Result.OK;
                }
            });
        }
    }

    public void lockDB(EntityManager sess) throws PersistenceException {
        this.m_dbGuard = (DbGuardPO)sess.find(DbGuardPO.class, (Object)this.m_dbGuard.getId());
        sess.lock((Object)this.m_dbGuard, LockModeType.PESSIMISTIC_WRITE);
    }

    public synchronized void startKeepAlive() {
        if (this.m_keepAliveThread == null) {
            this.m_keepAliveThread = new IsAliveThread(new Runnable(){

                @Override
                public void run() {
                    while (LockManager.this.m_keepRunning) {
                        LockManager.this.updateTimestamp();
                        LockManager.this.checkForTimeouts();
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }, "LockManger.KeepAlive");
            this.m_keepAliveThread.start();
        } else {
            log.warn(String.valueOf(Messages.KeepAliveAlreadyActive) + ".");
        }
    }

    public synchronized void dispose() {
        this.m_keepRunning = false;
        this.m_keepAliveThread.interrupt();
        this.runInSession(new DBRunnable(){

            @Override
            public Result run(EntityManager sess) {
                try {
                    if (LockManager.this.m_application != null) {
                        LockManager.this.removeApp(sess, LockManager.this.m_application);
                        LockManager.this.m_application = null;
                    }
                }
                catch (Throwable t) {
                    log.debug("application already removed", t);
                }
                return Result.OK;
            }
        });
        instance = null;
    }

    private void removeApp(EntityManager sess, ApplicationPO app) {
        Query delQuery = sess.createQuery("delete from DbLockPO lock where lock.application = :app");
        delQuery.setParameter("app", (Object)app);
        delQuery.executeUpdate();
        sess.remove(sess.getReference(ApplicationPO.class, (Object)app.getId()));
    }

    public synchronized boolean lockPO(final EntityManager userSess, final IPersistentObject po, final boolean checkVersion) throws PMDirtyVersionException, PMObjectDeletedException {
        if (LockManager.isRunning() && this.m_application != null) {
            DBRunnable checkForDirty = new DBRunnable(){

                @Override
                public Result run(EntityManager sess) {
                    Result result = Result.OK;
                    try {
                        if (checkVersion) {
                            Query versionQuery = sess.createQuery("select obj.version from " + po.getClass().getSimpleName() + " as obj where obj.id = :poID");
                            versionQuery.setParameter("poID", (Object)po.getId());
                            Integer version = (Integer)versionQuery.getSingleResult();
                            if (!po.getVersion().equals(version)) {
                                result = Result.OBJECT_DIRTY;
                            }
                        } else {
                            Query countQuery = sess.createQuery("select count(obj.id) from " + po.getClass().getSimpleName() + " as obj where obj.id = :poID");
                            countQuery.setParameter("poID", (Object)po.getId());
                            Long count = (Long)countQuery.getSingleResult();
                            if (count == 0L) {
                                result = Result.OBJECT_DELETED;
                            }
                        }
                    }
                    catch (NoResultException noResultException) {
                        result = Result.OBJECT_DELETED;
                    }
                    return result;
                }
            };
            Result runResult = this.runInSession(checkForDirty);
            if (runResult == Result.OBJECT_DELETED) {
                throw new PMObjectDeletedException(po, Messages.LockFailedDueToDeletedPO, MessageIDs.E_DELETED_OBJECT);
            }
            if (checkVersion && runResult == Result.OBJECT_DIRTY) {
                throw new PMDirtyVersionException(po, Messages.LockFailedDueToDbOutOfSync, MessageIDs.E_STALE_OBJECT);
            }
            return Result.OK == this.runInSession(new DBRunnable(){

                @Override
                public Result run(EntityManager sess) {
                    Result lockOK;
                    Query lockQuery = sess.createQuery("select lock from DbLockPO as lock where lock.poId = :poID");
                    lockQuery.setParameter("poID", (Object)po.getId());
                    try {
                        DbLockPO lock = (DbLockPO)lockQuery.getSingleResult();
                        lockOK = lock.getApplication().equals(LockManager.this.m_application) && lock.getSessionId() == System.identityHashCode(userSess) ? Result.OK : Result.FAILED;
                    }
                    catch (NoResultException noResultException) {
                        DbLockPO lock = new DbLockPO(LockManager.this.m_application, userSess, po);
                        sess.persist((Object)lock);
                        lockOK = Result.OK;
                    }
                    return lockOK;
                }
            });
        }
        return false;
    }

    public synchronized boolean lockPOs(EntityManager sess, Set<? extends IPersistentObject> objectsToLock, boolean checkVersion) throws PMDirtyVersionException, PMObjectDeletedException, PMAlreadyLockedException {
        IPersistentObject failedPO = null;
        Result runResult = Result.OK;
        for (IPersistentObject iPersistentObject : objectsToLock) {
            try {
                boolean lockResult = this.lockPO(sess, iPersistentObject, checkVersion);
                if (lockResult) continue;
                failedPO = iPersistentObject;
                runResult = Result.FAILED;
            }
            catch (PMDirtyVersionException pMDirtyVersionException) {
                failedPO = iPersistentObject;
                runResult = Result.OBJECT_DIRTY;
            }
            catch (PMObjectDeletedException pMObjectDeletedException) {
                failedPO = iPersistentObject;
                runResult = Result.OBJECT_DELETED;
            }
            break;
        }
        if (runResult != Result.OK) {
            this.handleLockProblems(failedPO, runResult);
        }
        return true;
    }

    private void handleLockProblems(IPersistentObject po, Result runResult) throws PMObjectDeletedException, PMDirtyVersionException, PMAlreadyLockedException {
        if (runResult == Result.FAILED) {
            String poName = po != null ? po.getName() : "";
            long poId = po != null ? po.getId() : -1L;
            throw new PMAlreadyLockedException(po, "PO " + po + " (name=" + poName + "; id=" + poId + ") locked in db.", MessageIDs.E_OBJECT_IN_USE);
        }
        if (runResult == Result.OBJECT_DELETED) {
            throw new PMObjectDeletedException(po, Messages.LockFailedDueToDeletedDOT, MessageIDs.E_DELETED_OBJECT);
        }
        if (runResult == Result.OBJECT_DIRTY) {
            throw new PMDirtyVersionException(po, Messages.LockFailedDueToDbOutOfSync, MessageIDs.E_DELETED_OBJECT);
        }
    }

    public synchronized void unlockPO(final IPersistentObject po) {
        this.runInSession(new DBRunnable(){

            @Override
            public Result run(EntityManager sess) {
                Query removeLockQuery = sess.createQuery("delete from DbLockPO lock where lock.poId = :poId");
                removeLockQuery.setParameter("poId", (Object)po.getId());
                return removeLockQuery.executeUpdate() > 0 ? Result.OK : Result.FAILED;
            }
        });
    }

    public static boolean isRunning() {
        return instance != null;
    }

    public synchronized void unlockPOs(final EntityManager s) {
        this.runInSession(new DBRunnable(){

            @Override
            public Result run(EntityManager sess) {
                Query removeLockQuery = sess.createQuery("delete from DbLockPO lock where lock.sessionId = :sessId");
                removeLockQuery.setParameter("sessId", (Object)System.identityHashCode(s));
                return removeLockQuery.executeUpdate() > 0 ? Result.OK : Result.FAILED;
            }
        });
    }

    public static void initDbGuard(EntityManager em) {
        DbGuardPO guard = new DbGuardPO();
        guard.setId(DB_GUARD_ID);
        em.merge((Object)guard);
    }

    public static interface DBRunnable {
        public Result run(EntityManager var1);
    }

    private static enum Result {
        OK,
        FAILED,
        OBJECT_DIRTY,
        OBJECT_DELETED;

    }
}

