/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.compcheck.ProblemPropagator;
import org.eclipse.jubula.client.core.businessprocess.db.TestJobBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.SpecTreeTraverser;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.tools.internal.constants.EnvConstants;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.InvalidAction;
import org.eclipse.jubula.tools.internal.xml.businessmodell.InvalidComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.InvalidParam;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemsBP
implements DataEventDispatcher.ICompletenessCheckListener,
DataEventDispatcher.IServerConnectionListener {
    private static ProblemsBP instance;
    private static final IWorkspaceRoot MARKER_ROOT;
    private static Logger log;
    private final Set<Integer> m_compNameProblemTypes = new HashSet<Integer>(Arrays.asList(ProblemType.REASON_ACTION_DOES_NOT_EXIST.ordinal(), ProblemType.REASON_COMP_DOES_NOT_EXIST.ordinal(), ProblemType.REASON_DEPRECATED_ACTION.ordinal(), ProblemType.REASON_DEPRECATED_COMP.ordinal(), ProblemType.REASON_NO_COMPTYPE.ordinal(), ProblemType.REASON_PARAM_DOES_NOT_EXIST.ordinal(), ProblemType.REASON_PROJECT_DOES_NOT_EXIST.ordinal()));
    private final Set<Integer> m_missingProjectProblemTypes = new HashSet<Integer>(Arrays.asList(ProblemType.REASON_PROJECT_DOES_NOT_EXIST.ordinal()));
    private List<IMarker> m_markerList = new ArrayList<IMarker>();
    private List<IMarker> m_markerToShowList = new ArrayList<IMarker>();
    private List<IProblem> m_allProblemsToShow = new ArrayList<IProblem>();
    private List<IProblem> m_localProblemsToShow = new ArrayList<IProblem>();

    static {
        MARKER_ROOT = ResourcesPlugin.getWorkspace().getRoot();
        log = LoggerFactory.getLogger(ProblemsBP.class);
    }

    private ProblemsBP() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addAutAgentConnectionListener((DataEventDispatcher.IServerConnectionListener)this, true);
        ded.addCompletenessCheckListener((DataEventDispatcher.ICompletenessCheckListener)this);
        this.doProblemsCheck(true, null);
    }

    public static ProblemsBP getInstance() {
        if (instance == null) {
            instance = new ProblemsBP();
        }
        return instance;
    }

    public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
        this.doProblemsCheck(false, state);
    }

    private void problemMissingReusedProject(IReusedProjectPO node, String label) {
        String message = NLS.bind((String)Messages.ProblemCheckerProjectDoesNotExist, (Object)label);
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", message), (String)message, (Object)node, (ProblemType)ProblemType.REASON_PROJECT_DOES_NOT_EXIST));
    }

    private void doProblemsCheck(boolean checkCompNamesPair, DataEventDispatcher.ServerState state) {
        this.clearOldProblems();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            if (TestSuiteBP.getListOfTestSuites().isEmpty()) {
                this.problemNoTestSuiteExists();
            }
            this.checkAllTestSuites();
            this.checkAllAutConfigs();
            this.checkAllTestJobs();
            if (project.getIsProtected()) {
                this.problemProtectedProjectLoaded();
            }
        }
        if (checkCompNamesPair) {
            this.checkCompNamesPairs();
        } else {
            this.copyCompNamesProblems();
        }
        if (checkCompNamesPair) {
            this.checkMissingProjects();
        } else {
            this.copyMissingProjectProblems();
        }
        this.checkServerState(state);
        this.collectAdditionalProblemsWhichShouldBeMarked();
        this.createMarkers();
        this.cleanupProblems();
        ProblemPropagator.INSTANCE.propagate();
    }

    private void collectAdditionalProblemsWhichShouldBeMarked() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return;
        }
        new TreeTraverser((INodePO)project, (ITreeNodeOperation)new CollectProblemsOperation(), false, true).traverse(true);
    }

    private void checkAllTestJobs() {
        for (ITestJobPO testJob : TestJobBP.getListOfTestJobs()) {
            List nodes = testJob.getUnmodifiableNodeList();
            for (INodePO node : nodes) {
                IRefTestSuitePO refTS;
                if (!(node instanceof IRefTestSuitePO) || !TestExecution.isAutNameSet((String)(refTS = (IRefTestSuitePO)node).getTestSuiteAutID())) continue;
                this.problemAUTNameNotSet(testJob, refTS);
            }
        }
    }

    private void problemAUTNameNotSet(ITestJobPO testJob, IRefTestSuitePO refTS) {
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.TestDataDecoratorRefTsIncomplTooltip), (String)NLS.bind((String)Messages.TestDataDecoratorRefTsIncompl, (Object)testJob.getName()), (Object)refTS, (ProblemType)ProblemType.NO_QUICKFIX));
    }

    public void clearOldProblems() {
        for (IProblem problem : this.m_localProblemsToShow) {
            Object data = problem.getData();
            if (!(data instanceof INodePO)) continue;
            INodePO node = (INodePO)data;
            node.removeProblem(problem);
        }
        this.m_markerToShowList.clear();
        this.m_localProblemsToShow.clear();
        this.m_allProblemsToShow.clear();
    }

    private void createMarkers() {
        this.m_allProblemsToShow.addAll(this.m_localProblemsToShow);
        for (IProblem problem : this.m_allProblemsToShow) {
            Object data = problem.getData();
            String location = data instanceof IPersistentObject ? ((IPersistentObject)data).getName() : "";
            this.createMarker(problem.getUserMessage(), this.getMarkerSeverity(problem), location, data, problem.getProblemType());
        }
    }

    private void copyCompNamesProblems() {
        for (IMarker marker : this.m_markerList) {
            if (!this.isCompNameRelated(marker) || this.m_markerToShowList.contains(marker)) continue;
            this.m_markerToShowList.add(marker);
        }
    }

    private void copyMissingProjectProblems() {
        for (IMarker marker : this.m_markerList) {
            if (!this.isMissingProjectRelated(marker) || this.m_markerToShowList.contains(marker)) continue;
            this.m_markerToShowList.add(marker);
        }
    }

    private boolean isCompNameRelated(IMarker marker) {
        try {
            return marker.getType().equals("org.eclipse.jubula.client.ui.rcp.jbProblem") && this.m_compNameProblemTypes.contains(marker.getAttribute("jbReason"));
        }
        catch (CoreException ce) {
            log.error(String.valueOf(Messages.CouldNotRetrieveTypeForMarker) + ":" + " " + marker + "." + " " + Messages.TheMarkerWillNotBeShown + ".", (Throwable)ce);
            return false;
        }
    }

    private boolean isMissingProjectRelated(IMarker marker) {
        try {
            return marker.getType().equals("org.eclipse.jubula.client.ui.rcp.jbProblem") && this.m_missingProjectProblemTypes.contains(marker.getAttribute("jbReason"));
        }
        catch (CoreException ce) {
            log.error(String.valueOf(Messages.CouldNotRetrieveTypeForMarker) + ":" + " " + marker + "." + " " + Messages.TheMarkerWillNotBeShown + ".", (Throwable)ce);
            return false;
        }
    }

    private void checkAllTestSuites() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project.getAutMainList().size() == 0) {
            this.problemNoAutForProjectExists();
        } else {
            this.checkAutConfigs();
        }
    }

    private int getMarkerSeverity(IProblem problem) {
        int statusSeverity = problem.getStatus().getSeverity();
        int markerSeverity = 0;
        if (statusSeverity == 2) {
            markerSeverity = 1;
        } else if (statusSeverity == 4 || statusSeverity == 8) {
            markerSeverity = 2;
        }
        return markerSeverity;
    }

    private void checkAutConfigs() {
        InetAddress connectedAUTAgent = null;
        try {
            if (!AutAgentConnection.getInstance().isConnected()) {
                return;
            }
            connectedAUTAgent = InetAddress.getByName(AutAgentConnection.getInstance().getCommunicator().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (ConnectionException connectionException) {
            return;
        }
        for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
            boolean isMatchingAUTAgent = false;
            InetAddress configAUTAgent = null;
            for (IAUTConfigPO config : aut.getAutConfigSet()) {
                try {
                    configAUTAgent = InetAddress.getByName(config.getConfiguredAUTAgentHostName());
                    if (!configAUTAgent.equals(connectedAUTAgent) && (configAUTAgent == null || !"127.0.0.1".equals(configAUTAgent.getHostAddress()) || !connectedAUTAgent.getCanonicalHostName().equals(EnvConstants.LOCALHOST_FQDN))) continue;
                    isMatchingAUTAgent = true;
                    break;
                }
                catch (UnknownHostException unknownHostException) {}
            }
            if (isMatchingAUTAgent) continue;
            this.problemNoAutConfigForServerExists(aut);
        }
    }

    private void checkAllAutConfigs() {
        Set autList = GeneralStorage.getInstance().getProject().getAutMainList();
        for (IAUTMainPO mainPO : autList) {
            for (IAUTConfigPO config : mainPO.getAutConfigSet()) {
                String jarFile = config.getValue("JAR_FILE", null);
                String classPath = config.getValue("CLASSPATH", null);
                if ("".equals(jarFile)) {
                    if ("".equals(classPath)) {
                        this.problemNoJarOrClassPathForAutConfigExists(config, mainPO);
                    }
                } else if ("".equals(classPath) && "".equals(jarFile)) {
                    this.problemNoJarOrClassPathForAutConfigExists(config, mainPO);
                }
                if (!"".equals(config.getConfiguredAUTAgentHostName())) continue;
                this.problemNoServerForAutConfigExists(config, mainPO);
            }
        }
    }

    private void checkServerState(DataEventDispatcher.ServerState state) {
        boolean isServerDefined;
        String serverPortPref = Plugin.getDefault().getPreferenceStore().getString("AUT_AGENT_SETTINGS_KEY");
        boolean bl = isServerDefined = serverPortPref.length() != 0;
        if (!isServerDefined) {
            this.problemNoServerDefined();
        }
    }

    private void createMarker(String message, int messageType, String location, Object object, ProblemType type) {
        boolean existProblem = false;
        for (IMarker marker : this.m_markerList) {
            try {
                if (!marker.getAttribute("location").equals(location) || !marker.getAttribute("severity").equals(messageType) || !marker.getAttribute("message").equals(message) || (object == null || !new Integer(object.hashCode()).equals(marker.getAttribute("jbObjectHashCode"))) && (object != null || marker.getAttribute("jbObjectHashCode") != null)) continue;
                existProblem = true;
                this.m_markerToShowList.add(marker);
            }
            catch (CoreException coreException) {}
        }
        if (existProblem) {
            return;
        }
        try {
            IMarker marker;
            marker = MARKER_ROOT.createMarker("org.eclipse.jubula.client.ui.rcp.jbProblem");
            marker.setAttribute("location", (Object)location);
            marker.setAttribute("severity", messageType);
            marker.setAttribute("message", (Object)message);
            if (object != null) {
                marker.setAttribute("jbObjectHashCode", object.hashCode());
            } else {
                marker.setAttribute("jbObjectHashCode", null);
            }
            marker.setAttribute("jbReason", type.ordinal());
            if (object instanceof INodePO) {
                INodePO node = (INodePO)object;
                marker.setAttribute("jbObjectName", (Object)node.getName());
                marker.setAttribute("jbNodeGUID", (Object)node.getGuid());
            } else {
                if (object instanceof String) {
                    marker.setAttribute("jbObjectName", object);
                } else {
                    marker.setAttribute("jbObjectName", (Object)"");
                }
                marker.setAttribute("jbNodeGUID", (Object)"");
            }
            this.m_markerList.add(marker);
            this.m_markerToShowList.add(marker);
        }
        catch (CoreException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private IMarker[] findProblems() {
        String type = "org.eclipse.jubula.client.ui.rcp.jbProblem";
        IMarker[] markers = null;
        try {
            markers = MARKER_ROOT.findMarkers(type, true, 2);
        }
        catch (CoreException coreException) {}
        return markers;
    }

    public void cleanupProblems() {
        boolean doLoop = true;
        block4: while (doLoop) {
            doLoop = false;
            for (IMarker marker : this.m_markerList) {
                if (this.m_markerToShowList.contains(marker)) continue;
                try {
                    this.m_markerList.remove(marker);
                    marker.delete();
                }
                catch (CoreException coreException) {}
                doLoop = true;
                continue block4;
            }
        }
        IMarker[] iMarkerArray = this.findProblems();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker;
            marker = iMarkerArray[n2];
            if (!this.m_markerList.contains(marker) || !this.m_markerToShowList.contains(marker)) {
                try {
                    this.m_markerList.remove(marker);
                    this.m_markerToShowList.remove(marker);
                    marker.delete();
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    private void problemProtectedProjectLoaded() {
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(1, "org.eclipse.jubula.client.core", Messages.ProblemCheckerProtectedProject), (String)Messages.ProblemCheckerProtectedProject, (Object)Messages.ProtectedProject, (ProblemType)ProblemType.REASON_PROTECTED_PROJECT));
    }

    private void problemNoServerDefined() {
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.ProblemCheckerNoServer), (String)Messages.ProblemCheckerNoServer, (Object)Messages.NoServer, (ProblemType)ProblemType.REASON_NO_SERVER_DEFINED));
    }

    private void problemNoTestSuiteExists() {
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(1, "org.eclipse.jubula.client.core", Messages.ProblemCheckerNoTestSuite), (String)Messages.ProblemCheckerNoTestSuite, (Object)Messages.Project, (ProblemType)ProblemType.REASON_NO_TESTSUITE));
    }

    private void problemNoAutForProjectExists() {
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.ProblemCheckerNoAutExists), (String)Messages.ProblemCheckerNoAutExists, (Object)Messages.Project, (ProblemType)ProblemType.REASON_NO_AUT_FOR_PROJECT_EXISTS));
    }

    private void problemNoJarOrClassPathForAutConfigExists(IAUTConfigPO config, IAUTMainPO aut) {
        String message = NLS.bind((String)Messages.ProblemCheckerAutConfigMissesJar, (Object[])new String[]{config.getName(), aut.getName()});
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", message), (String)message, (Object)(String.valueOf(Messages.ProblemCheckerAUT) + aut.getName()), (ProblemType)ProblemType.REASON_NO_JAR_FOR_AUTCONFIG));
    }

    private void problemNoServerForAutConfigExists(IAUTConfigPO config, IAUTMainPO aut) {
        String message = NLS.bind((String)Messages.ProblemCheckerAutConfigMissesJar, (Object[])new String[]{config.getName(), aut.getName()});
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", message), (String)message, (Object)(String.valueOf(Messages.ProblemCheckerAUT) + aut.getName()), (ProblemType)ProblemType.REASON_NO_SERVER_FOR_AUTCONFIG));
    }

    private void problemNoAutConfigForServerExists(IAUTMainPO aut) {
        String message = NLS.bind((String)Messages.ProblemCheckerAutNoConfigurationForServer, (Object)aut.getName());
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", message), (String)message, (Object)(String.valueOf(Messages.ProblemCheckerAUT) + aut.getName()), (ProblemType)ProblemType.REASON_NO_AUTCONFIG_FOR_SERVER_EXIST));
    }

    private void checkCompNamesPairs() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return;
        }
        CheckProblemsOperation op = new CheckProblemsOperation();
        TreeTraverser traverser = new TreeTraverser((INodePO)project, (ITreeNodeOperation)op, false, true);
        CheckForDeprecatedModulesOperation operation = new CheckForDeprecatedModulesOperation();
        traverser.addOperation((ITreeNodeOperation)operation);
        traverser.traverse();
        SpecTreeTraverser specTreeTraverser = new SpecTreeTraverser((INodePO)project, (ITreeNodeOperation)op);
        specTreeTraverser.addOperation((ITreeNodeOperation)operation);
        specTreeTraverser.traverse();
    }

    private void checkMissingProjects() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return;
        }
        for (IReusedProjectPO reused : project.getUsedProjects()) {
            boolean reusedProjectExists = false;
            try {
                reusedProjectExists = ProjectPM.loadProjectFromMaster((IReusedProjectPO)reused) != null;
            }
            catch (JBException jBException) {}
            if (reusedProjectExists) continue;
            this.problemMissingReusedProject(null, reused.getName());
        }
    }

    private void problemDeprecatedActionFound(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        String message = NLS.bind((String)Messages.ProblemCheckerDeprecatedAction, (Object[])new String[]{cap.getName(), tcPO.getName()});
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", message), (String)message, (Object)cap, (ProblemType)ProblemType.REASON_DEPRECATED_ACTION));
    }

    private void problemDeprecatedCompFound(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        String message = NLS.bind((String)Messages.ProblemCheckerDeprecatedAction, (Object[])new String[]{cap.getName(), tcPO.getName()});
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", message), (String)message, (Object)cap, (ProblemType)ProblemType.REASON_DEPRECATED_COMP));
    }

    private void problemCompDoesNotExist(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        String message = NLS.bind((String)Messages.ProblemCheckerCompDoesNotExist, (Object[])new String[]{cap.getName(), tcPO.getName(), CompSystemI18n.getString((String)cap.getComponentType(), (boolean)true)});
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(4, "org.eclipse.jubula.client.core", message), (String)message, (Object)cap, (ProblemType)ProblemType.REASON_COMP_DOES_NOT_EXIST));
    }

    private void problemActionDoesNotExist(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        String message = NLS.bind((String)Messages.ProblemCheckerCompDoesNotExist, (Object[])new String[]{cap.getName(), tcPO.getName(), cap.getComponentName()});
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(4, "org.eclipse.jubula.client.core", message), (String)message, (Object)cap, (ProblemType)ProblemType.REASON_COMP_DOES_NOT_EXIST));
    }

    private void problemParamDoesNotExist(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        String message = NLS.bind((String)Messages.ProblemCheckerCompDoesNotExist, (Object[])new String[]{cap.getName(), tcPO.getName(), cap.getComponentName()});
        this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(4, "org.eclipse.jubula.client.core", message), (String)message, (Object)cap, (ProblemType)ProblemType.REASON_COMP_DOES_NOT_EXIST));
    }

    public void completenessCheckFinished() {
        this.doProblemsCheck(true, null);
    }

    public void completenessCheckStarted() {
    }

    private final class CheckForDeprecatedModulesOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private CheckForDeprecatedModulesOperation() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof ICapPO) {
                ICapPO capPO = (ICapPO)node;
                if (capPO.getMetaAction().isDeprecated()) {
                    ProblemsBP.this.problemDeprecatedActionFound(capPO);
                }
                if (capPO.getMetaComponentType().isDeprecated()) {
                    ProblemsBP.this.problemDeprecatedCompFound(capPO);
                }
            }
            return true;
        }
    }

    private final class CheckProblemsOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private CheckProblemsOperation() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            block7: {
                block6: {
                    boolean hasCompleteTestCaseReferences;
                    if (!(node instanceof IExecTestCasePO)) break block6;
                    IExecTestCasePO execTC = (IExecTestCasePO)node;
                    boolean bl = hasCompleteTestCaseReferences = !execTC.getProblems().contains(ProblemFactory.MISSING_NODE);
                    if (!hasCompleteTestCaseReferences) break block7;
                    for (ICompNamesPairPO pair : execTC.getCompNamesPairs()) {
                        String type = Utils.getComponentType(execTC, pair.getFirstName());
                        pair.setType(type);
                        if (type != null && !"".equals(type)) continue;
                        this.problemNoCompTypeForCompNamesPairExists(execTC);
                    }
                    break block7;
                }
                if (node instanceof ICapPO) {
                    String message;
                    ICapPO cap = (ICapPO)node;
                    if (cap.getMetaComponentType() instanceof InvalidComponent) {
                        message = String.valueOf(Messages.Component) + ":" + " " + cap.getComponentType();
                        log.error(String.valueOf(Messages.CouldNotFind) + " " + message);
                        ProblemsBP.this.problemCompDoesNotExist(cap);
                    } else if (cap.getMetaAction() instanceof InvalidAction) {
                        message = String.valueOf(Messages.CouldNotFindAction) + " " + CompSystemI18n.getString((String)cap.getActionName(), (boolean)true) + "\n" + "in" + " " + Messages.Component + ":" + " " + cap.getComponentType();
                        log.error(message);
                        ProblemsBP.this.problemActionDoesNotExist(cap);
                    }
                    for (Object paramObj : cap.getParameterList()) {
                        if (!(paramObj instanceof InvalidParam)) continue;
                        Param param = (Param)paramObj;
                        String message2 = String.valueOf(Messages.Component) + ":" + " " + cap.getComponentType() + "\n" + Messages.Action + ":" + " " + CompSystemI18n.getString((String)cap.getActionName(), (boolean)true) + "\n" + Messages.Parameter + ":" + " " + CompSystemI18n.getString((String)param.getName(), (boolean)true);
                        log.error(String.valueOf(Messages.CouldNotFind) + " " + message2);
                        ProblemsBP.this.problemParamDoesNotExist(cap);
                    }
                }
            }
            return true;
        }

        private void problemNoCompTypeForCompNamesPairExists(IExecTestCasePO execTC) {
            INodePO parentNode = execTC.getParentNode();
            if (parentNode == null) {
                return;
            }
            String name = parentNode.getName();
            if ("".equals(name) && parentNode instanceof IExecTestCasePO) {
                name = ((IExecTestCasePO)parentNode).getSpecTestCase().getName();
            }
            ProblemsBP.this.m_localProblemsToShow.add(ProblemFactory.createProblemWithMarker((IStatus)new Status(2, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ProblemCheckerNoCompType, (Object)name)), (String)NLS.bind((String)Messages.ProblemCheckerNoCompType, (Object)name), (Object)parentNode, (ProblemType)ProblemType.REASON_NO_COMPTYPE));
        }
    }

    private final class CollectProblemsOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private CollectProblemsOperation() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (ProblemFactory.hasProblem((INodePO)node)) {
                for (IProblem problem : node.getProblems()) {
                    if (!problem.hasUserMessage()) continue;
                    ProblemsBP.this.m_allProblemsToShow.add(problem);
                }
            }
            return true;
        }
    }
}

