/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.NewCommentDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewCommentHandler
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractJBEditor) {
            final AbstractJBEditor tce = (AbstractJBEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    INodePO workTC = (INodePO)workingPo;
                    IStructuredSelection selection = NewCommentHandler.this.getSelection();
                    int posistionToAdd = 0;
                    INodePO selectedNode = (INodePO)selection.getFirstElement();
                    if (selectedNode != null) {
                        posistionToAdd = workTC.indexOf(selectedNode);
                    }
                    NewCommentHandler.this.addComment(workTC, posistionToAdd, tce);
                }
            });
        }
        return null;
    }

    private void addComment(INodePO workTC, Integer position, AbstractJBEditor editor) {
        NewCommentDialog dialog = new NewCommentDialog(this.getActiveShell());
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        ICommentPO comment = NodeMaker.createCommentPO((String)dialog.getCommentText());
        workTC.addNode(position.intValue(), (INodePO)comment);
        editor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)comment, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
    }
}

