/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractRunningAutHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.KeyConverter;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartObjectMappingModeHandler
extends AbstractRunningAutHandler {
    public static final String RUNNING_AUT = "org.eclipse.jubula.client.ui.rcp.commands.OMStartMappingModeCommand.parameter.runningAut";
    private static final Logger LOG = LoggerFactory.getLogger(StartObjectMappingModeHandler.class);

    public Object executeImpl(ExecutionEvent event) {
        AutIdentifier runningAut = this.getRunningAut(event, RUNNING_AUT);
        IAUTMainPO mappingAut = AutAgentRegistration.getAutForId((AutIdentifier)runningAut, (IProjectPO)GeneralStorage.getInstance().getProject());
        ObjectMappingMultiPageEditor omEditor = null;
        if (!(Plugin.getActiveEditor() instanceof ObjectMappingMultiPageEditor) && Utils.getEditorByPO((IPersistentObject)mappingAut) != null) {
            IEditorPart toActivate = Utils.getEditorByPO((IPersistentObject)mappingAut);
            toActivate.getSite().getPage().activate((IWorkbenchPart)toActivate);
            if (toActivate instanceof ObjectMappingMultiPageEditor) {
                omEditor = (ObjectMappingMultiPageEditor)toActivate;
            }
        }
        if (omEditor == null) {
            AbstractOpenHandler.openEditor((IPersistentObject)mappingAut);
            IEditorPart activeEditor = Plugin.getActiveEditor();
            if (activeEditor instanceof ObjectMappingMultiPageEditor) {
                omEditor = (ObjectMappingMultiPageEditor)activeEditor;
            }
        }
        if (omEditor == null) {
            if (runningAut == null) {
                LOG.error(Messages.CouldNotOpenOMEditorNoAUT);
            } else {
                LOG.error(String.valueOf(Messages.CouldNotOpenOMEditorForAUT) + ":" + " " + runningAut.getExecutableName());
            }
            return null;
        }
        IObjectMappingCategoryPO unMappedTech = omEditor.getAut().getObjMap().getUnmappedTechnicalCategory();
        DataEventDispatcher.getInstance().fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Connecting);
        this.startMappingMode(runningAut, omEditor, unMappedTech);
        return null;
    }

    private void startMappingMode(AutIdentifier autId, ObjectMappingMultiPageEditor editor, IObjectMappingCategoryPO unmappedTechNames) {
        IStructuredSelection selection;
        IObjectMappingCategoryPO category = null;
        TreeViewer treeViewer = editor.getTreeViewer();
        if (treeViewer != null && (treeViewer.getSelection() instanceof IStructuredSelection || treeViewer.getContentProvider() instanceof ITreeContentProvider) && (selection = (IStructuredSelection)treeViewer.getSelection()).size() == 1) {
            Object node = selection.getFirstElement();
            if (node instanceof IObjectMappingCategoryPO && OMEditorDndSupport.getSection((IObjectMappingCategoryPO)node).equals(unmappedTechNames)) {
                category = (IObjectMappingCategoryPO)node;
            } else if (node instanceof IObjectMappingAssoziationPO && OMEditorDndSupport.getSection((IObjectMappingAssoziationPO)node).equals(unmappedTechNames)) {
                category = ((IObjectMappingAssoziationPO)node).getCategory();
            }
            if (category != null) {
                editor.getOmEditorBP().setCategoryToCreateIn(category);
            } else {
                ObjectMappingEventDispatcher.setCategoryToCreateIn(null);
            }
        }
        if (!AutAgentRegistration.getInstance().getRegisteredAuts().contains(autId)) {
            String message = Messages.OMStartMappingModeActionError1;
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(message, MessageIDs.E_UNEXPECTED_EXCEPTION), null, (String[])new String[]{message});
        } else {
            IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
            int mappingMod = preferenceStore.getInt("MAPPINGMOD1_PREF_KEY");
            int mappingKey = preferenceStore.getInt("MAPPINGMOD2_PREF_KEY");
            int mappingType = preferenceStore.getInt("MAPPINGMOD2_TYPE_PREF_KEY");
            int mappingWPMod = preferenceStore.getInt("MAPPING_WITH_PARENTS_MOD1_PREF_KEY");
            int mappingWPKey = preferenceStore.getInt("MAPPING_WITH_PARENTS_MOD2_PREF_KEY");
            int mappingWPType = preferenceStore.getInt("MAPPING_WITH_PARENTS_MOD2_TYPE_PREF_KEY");
            String toolkit = editor.getAut().getToolkit();
            if (toolkit.equals("com.bredexsw.guidancer.SwtToolkitPlugin") || toolkit.equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
                mappingMod = KeyConverter.convertSwingStateMask(mappingMod);
                mappingKey = KeyConverter.convertSwingToSwt(mappingKey);
            }
            StartObjectMappingModeJob startObjectMappingModeJob = new StartObjectMappingModeJob(editor, autId, mappingMod, mappingKey, category, mappingType, mappingWPMod, mappingWPKey, mappingWPType);
            startObjectMappingModeJob.setSystem(true);
            JobUtils.executeJob((Job)startObjectMappingModeJob, null);
        }
    }

    private static class StartObjectMappingModeJob
    extends Job {
        private ObjectMappingMultiPageEditor m_editor;
        private AutIdentifier m_autId;
        private int m_modifier;
        private int m_key;
        private int m_modifierWithParents;
        private int m_keyWithParents;
        private IObjectMappingCategoryPO m_category;
        private int m_type;
        private int m_typeWithParents;

        public StartObjectMappingModeJob(ObjectMappingMultiPageEditor editor, AutIdentifier autId, int modifier, int key, IObjectMappingCategoryPO category, int type, int modifierWP, int keyWP, int typeWP) {
            super("Start Object Mapping Mode");
            this.m_editor = editor;
            this.m_autId = autId;
            this.m_modifier = modifier;
            this.m_key = key;
            this.m_category = category;
            this.m_type = type;
            this.m_modifierWithParents = modifierWP;
            this.m_keyWithParents = keyWP;
            this.m_typeWithParents = typeWP;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                TestExecutionContributor.getInstance().getClientTest().startObjectMapping(this.m_autId, this.m_modifier, this.m_key, this.m_type, this.m_modifierWithParents, this.m_keyWithParents, this.m_typeWithParents);
                DataEventDispatcher.getInstance().fireOMStateChanged(DataEventDispatcher.OMState.running);
                DataEventDispatcher.getInstance().fireOMAutChanged(this.m_autId);
                ObjectMappingEventDispatcher.setCategoryToCreateIn((IObjectMappingCategoryPO)this.m_category);
                this.m_editor.getOmEditorBP().setCategoryToCreateIn(this.m_category);
            }
            catch (CommunicationException ce) {
                LOG.error(Messages.ErrorStartingObjectMappingMode, (Throwable)ce);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof StartObjectMappingModeHandler) {
                return true;
            }
            return super.belongsTo(family);
        }
    }
}

