/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.existing.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.InteractionEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.TestCaseTreeDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.handlers.NewTestCaseHandlerTCEditor;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReferenceExistingTestCase
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        final AbstractTestCaseEditor tce = (AbstractTestCaseEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

            @Override
            public void run(IPersistentObject workingPo) {
                INodePO editorNode = (INodePO)workingPo;
                INodePO node = (INodePO)ReferenceExistingTestCase.this.getSelection().getFirstElement();
                if (node == null) {
                    return;
                }
                ISelectionListener listener = ReferenceExistingTestCase.this.getSelectionListener(tce, editorNode, node);
                ISpecTestCasePO specTC = null;
                if (editorNode instanceof ISpecTestCasePO) {
                    specTC = (ISpecTestCasePO)editorNode;
                }
                TestCaseTreeDialog dialog = new TestCaseTreeDialog(ReferenceExistingTestCase.this.getActiveShell(), specTC, 2);
                dialog.addSelectionListener(listener);
                dialog.setHelpAvailable(true);
                dialog.create();
                DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.testCaseAddExistingContextId");
                dialog.open();
                dialog.removeSelectionListener(listener);
            }
        });
        return null;
    }

    private ISelectionListener getSelectionListener(final AbstractTestCaseEditor tce, final INodePO editorNode, final INodePO node) {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                List selectedElements = ((IStructuredSelection)selection).toList();
                Collections.reverse(selectedElements);
                Iterator iter = selectedElements.iterator();
                ArrayList<IExecTestCasePO> addedElements = new ArrayList<IExecTestCasePO>();
                try {
                    while (iter.hasNext()) {
                        ISpecTestCasePO specTcToInsert = (ISpecTestCasePO)iter.next();
                        try {
                            Integer index = null;
                            if (node instanceof IExecTestCasePO) {
                                index = NewTestCaseHandlerTCEditor.getPositionToInsert(editorNode, node);
                            }
                            addedElements.add(TestCaseBP.addReferencedTestCase((EditSupport)tce.getEditorHelper().getEditSupport(), (INodePO)editorNode, (ISpecTestCasePO)specTcToInsert, (Integer)index));
                        }
                        catch (PMException e) {
                            NodeEditorInput inp = (NodeEditorInput)tce.getAdapter(NodeEditorInput.class);
                            INodePO inpNode = inp.getNode();
                            PMExceptionHandler.handlePMExceptionForMasterSession(e);
                            tce.reOpenEditor((IPersistentObject)inpNode);
                        }
                        InteractionEventDispatcher.getDefault().fireProgammableSelectionEvent((IStructuredSelection)new StructuredSelection((Object)specTcToInsert));
                    }
                    tce.getEditorHelper().getEditSupport().lockWorkVersion();
                    tce.getEditorHelper().setDirty(true);
                    tce.setSelection((ISelection)new StructuredSelection(addedElements));
                }
                catch (PMException e1) {
                    PMExceptionHandler.handlePMExceptionForEditor(e1, tce);
                }
            }
        };
    }
}

