/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.pages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.factory.ControlFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedProjectNameText;
import org.eclipse.jubula.client.ui.rcp.wizards.ProjectWizard;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProjectSettingWizardPage
extends WizardPage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final String DEFAULT_TOOLKIT = "com.bredexsw.guidancer.ConcreteToolkitPlugin";
    private IProjectPO m_project = null;
    private String m_newProjectName = null;
    private boolean m_isProjectReusable = false;
    private boolean m_isProjectProtected = false;
    private DirectCombo<String> m_autToolKitComboBox;
    private Text m_projectNameTextField;
    private Button m_projectReusabilityCheckbox;
    private Button m_projectProtectionCheckbox;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private final WidgetModifyListener m_modifyListener = new WidgetModifyListener();

    public ProjectSettingWizardPage(String pageName, IProjectPO newProject) {
        super(pageName);
        this.setPageComplete(false);
        this.m_project = newProject;
        this.m_newProjectName = this.m_project.getName();
        this.m_isProjectReusable = this.m_project.getIsReusable();
        this.m_isProjectProtected = this.m_project.getIsProtected();
    }

    public DirectCombo<String> getToolkitComboBox() {
        return this.m_autToolKitComboBox;
    }

    public void createControl(Composite parent) {
        ScrolledComposite scroll = new ScrolledComposite(parent, 768);
        Composite composite = this.createComposite((Composite)scroll, 1, 4, false);
        Composite projectNameComposite = this.createComposite(composite, 2, 4, false);
        this.createLabel(projectNameComposite, "");
        this.createLabel(projectNameComposite, "");
        this.createProjectNameField(projectNameComposite);
        this.createLabel(projectNameComposite, "");
        this.createLabel(projectNameComposite, "");
        this.createIsReusableCheckbox(projectNameComposite);
        this.createIsProtectedCheckbox(projectNameComposite);
        this.createLabel(projectNameComposite, "");
        this.separator(projectNameComposite, 2);
        this.createLabel(projectNameComposite, "");
        this.createAutToolKit(projectNameComposite);
        this.separator(projectNameComposite, 2);
        this.createNextLabel(composite);
        this.addListener();
        this.setMessage(Messages.ProjectWizardNewProject, 0);
        Plugin.getHelpSystem().setHelp((Control)composite, "org.eclipse.jubula.client.ua.help.projectWizardContextId");
        scroll.setContent((Control)composite);
        scroll.setMinSize(composite.computeSize(-1, -1));
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        this.setControl((Control)scroll);
        this.checkCompleteness(true);
    }

    private void createIsReusableCheckbox(Composite composite) {
        Composite leftComposite = this.createComposite(composite, 1, 1, false);
        Composite rightComposite = this.createComposite(composite, 1, 4, true);
        ControlDecorator.decorateInfo((Control)this.createLabel(leftComposite, Messages.ProjectPropertyPageIsReusable), "ControlDecorator.NewProjectIsReusable", false);
        this.m_projectReusabilityCheckbox = new Button(rightComposite, 32);
        this.m_projectReusabilityCheckbox.setSelection(false);
    }

    private void createIsProtectedCheckbox(Composite composite) {
        Composite leftComposite = this.createComposite(composite, 1, 1, false);
        Composite rightComposite = this.createComposite(composite, 1, 4, true);
        ControlDecorator.decorateInfo((Control)this.createLabel(leftComposite, Messages.ProjectPropertyPageIsProtected), "ControlDecorator.NewProjectIsProtected", false);
        this.m_projectProtectionCheckbox = new Button(rightComposite, 32);
        this.m_projectProtectionCheckbox.setSelection(false);
    }

    private void createNextLabel(Composite composite) {
        Label nextLabel = new Label(composite, 0);
        nextLabel.setText(Messages.ProjectSettingWizardPageClickNext);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        nextLabel.setLayoutData((Object)data);
    }

    private void createAutToolKit(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 2, 1, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 4;
        leftComposite.setLayout((Layout)gridLayout);
        rightComposite.setLayout((Layout)gridLayout);
        ControlDecorator.decorateInfo((Control)this.createLabel(leftComposite, Messages.ProjectSettingWizardPageAutToolKitLabel), "ControlDecorator.NewProjectToolkit", false);
        this.m_autToolKitComboBox = ControlFactory.createToolkitCombo(rightComposite);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGridData, this.m_autToolKitComboBox);
        this.m_autToolKitComboBox.setLayoutData((Object)comboGridData);
        String projectToolkit = this.m_project.getToolkit();
        if (projectToolkit != null && projectToolkit.length() > 0) {
            this.m_autToolKitComboBox.setSelectedObject((Object)projectToolkit);
        } else {
            this.m_autToolKitComboBox.setSelectedObject((Object)DEFAULT_TOOLKIT);
        }
    }

    private void separator(Composite composite, int horSpan) {
        this.createLabel(composite, "");
        Label sep = new Label(composite, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.horizontalSpan = horSpan;
        sep.setLayoutData((Object)sepData);
        this.createLabel(composite, "");
    }

    private void createProjectNameField(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 2, 1, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        rightComposite.setLayout((Layout)gridLayout);
        this.createLabel(leftComposite, Messages.ProjectSettingWizardPageProjectName);
        this.m_projectNameTextField = new CheckedProjectNameText(rightComposite, 2048);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        this.m_projectNameTextField.setLayoutData((Object)textGridData);
        LayoutUtil.setMaxChar((Text)this.m_projectNameTextField);
        this.m_projectNameTextField.setText(Messages.ProjectSettingWizardPageDefaultProjectName);
        this.m_projectNameTextField.setSelection(0, this.m_projectNameTextField.getText().length());
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns, int alignment, boolean horizontalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = alignment;
        compositeData.grabExcessHorizontalSpace = horizontalSpace;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    private void confirmNextButton() {
        if (this.m_project != null) {
            this.m_newProjectName = this.m_projectNameTextField.getText();
            this.m_isProjectReusable = this.m_projectReusabilityCheckbox.getSelection();
            this.m_isProjectProtected = this.m_projectProtectionCheckbox.getSelection();
            this.m_project.setToolkit((String)this.m_autToolKitComboBox.getSelectedObject());
        }
    }

    public void dispose() {
        this.removeListener();
        super.dispose();
    }

    private void addListener() {
        this.m_projectNameTextField.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_autToolKitComboBox.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_projectReusabilityCheckbox.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_projectProtectionCheckbox.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void removeListener() {
        if (this.m_project != null) {
            this.m_projectNameTextField.removeModifyListener((ModifyListener)this.m_modifyListener);
            this.m_projectReusabilityCheckbox.removeSelectionListener((SelectionListener)this.m_selectionListener);
            this.m_projectProtectionCheckbox.removeSelectionListener((SelectionListener)this.m_selectionListener);
        }
    }

    private void checkCompleteness(boolean isAUTNameModified) {
        if (this.modifyProjectNameFieldAction(isAUTNameModified)) {
            this.setPageComplete(true);
            this.confirmNextButton();
            return;
        }
        this.setPageComplete(false);
    }

    private boolean modifyProjectNameFieldAction(boolean isProjectNameModiyfied) {
        boolean isCorrect = true;
        String projectName = this.m_projectNameTextField.getText();
        int projectNameLength = projectName.length();
        if (projectNameLength == 0 || projectName.startsWith(" ") || projectName.charAt(projectNameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (isCorrect) {
            this.setMessage(Messages.ProjectWizardNewProject, 0);
            if (ProjectPM.doesProjectNameExist((String)projectName) && !this.m_project.getName().equals(projectName)) {
                this.setMessage(Messages.ProjectSettingWizardPageDoubleProjectName, 3);
                isCorrect = false;
            }
        } else if (projectNameLength == 0) {
            this.setMessage(Messages.ProjectWizardEmptyProject, 3);
        } else {
            this.setMessage(Messages.ProjectWizardNotValidProject, 3);
        }
        return isCorrect;
    }

    public ProjectWizard getWizard() {
        return (ProjectWizard)super.getWizard();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.projectWizardContextId");
    }

    public String getNewProjectName() {
        return this.m_newProjectName;
    }

    public boolean isProjectReusable() {
        return this.m_isProjectReusable;
    }

    public boolean isProjectProtected() {
        return this.m_isProjectProtected;
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectSettingWizardPage.this.m_projectNameTextField)) {
                ProjectSettingWizardPage.this.checkCompleteness(true);
                return;
            }
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectSettingWizardPage.this.m_autToolKitComboBox)) {
                this.handleToolkitCombo();
                return;
            }
            if (o.equals(ProjectSettingWizardPage.this.m_projectReusabilityCheckbox)) {
                boolean isReusable = ProjectSettingWizardPage.this.m_projectReusabilityCheckbox.getSelection();
                if (isReusable) {
                    ProjectSettingWizardPage.this.m_projectProtectionCheckbox.setSelection(true);
                }
                ProjectSettingWizardPage.this.checkCompleteness(false);
                return;
            }
            if (o.equals(ProjectSettingWizardPage.this.m_projectProtectionCheckbox)) {
                ProjectSettingWizardPage.this.checkCompleteness(false);
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + ":" + " " + "'" + String.valueOf(o) + "'"));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectSettingWizardPage.this.m_autToolKitComboBox)) {
                this.handleToolkitCombo();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + ":" + " " + "'" + String.valueOf(o) + "'"));
        }

        private void handleToolkitCombo() {
            ProjectSettingWizardPage.this.m_project.setToolkit((String)ProjectSettingWizardPage.this.m_autToolKitComboBox.getSelectedObject());
        }
    }
}

