/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.AbstractMatchSelectionPage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.DecoratedCombo;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ReplaceExecTestCaseData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ParameterNamesMatchingWizardPage
extends AbstractMatchSelectionPage
implements SelectionListener {
    private final ReplaceExecTestCaseData m_replaceExecTestCasesData;
    private ISpecTestCasePO m_lastNewSpecTestCase;
    private List<Combo> m_oldNameCombos = new ArrayList<Combo>();

    public ParameterNamesMatchingWizardPage(String pageName, ReplaceExecTestCaseData replaceExecTestCasesData) {
        super(pageName, Messages.ReplaceTCRWizard_matchParameterNames_title, null);
        this.m_replaceExecTestCasesData = replaceExecTestCasesData;
        this.setDescription(Messages.ReplaceTCRWizard_matchParameterNames_multi_description);
    }

    @Override
    protected void createSelectionTable(Composite parent) {
        if (this.m_lastNewSpecTestCase == this.m_replaceExecTestCasesData.getNewSpecTestCase()) {
            return;
        }
        this.m_lastNewSpecTestCase = this.m_replaceExecTestCasesData.getNewSpecTestCase();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        ParameterNamesMatchingWizardPage.createHeadLabel(parent, Messages.ReplaceTCRWizard_matchParameterNames_newParameter);
        ParameterNamesMatchingWizardPage.createHeadLabel(parent, Messages.ReplaceTCRWizard_matchParameterNames_oldParameter);
        List paramDescList = this.m_replaceExecTestCasesData.getNewSpecTestCase().getParameterList();
        this.m_oldNameCombos.clear();
        for (IParamDescriptionPO paramDesc : paramDescList) {
            ParameterNamesMatchingWizardPage.createLabel(parent, GeneralLabelProvider.getTextWithType(paramDesc));
            List<String> oldNames = this.m_replaceExecTestCasesData.getOldParameterNamesByType(paramDesc);
            if (oldNames.size() == 0) {
                Label label = ParameterNamesMatchingWizardPage.createLabel(parent, Messages.ReplaceTCRWizard_matchParameterNames_warningNoSameType);
                ControlDecorator.addWarningDecorator((Control)label, Messages.ReplaceTCRWizard_matchParameterNames_warningNoSameTypeDesc);
                this.m_oldNameCombos.add(null);
                continue;
            }
            String message = NLS.bind((String)Messages.ReplaceTCRWizard_matchParameterNames_warnUnmatchedParams, (Object)this.m_replaceExecTestCasesData.getOldSpecTestCase().getName());
            int selectedIndex = 0;
            if (oldNames.contains(paramDesc.getName())) {
                selectedIndex = oldNames.indexOf(paramDesc.getName()) + 1;
            }
            Combo combo = DecoratedCombo.create(parent, oldNames, selectedIndex, message);
            combo.setLayoutData((Object)new GridData(768));
            combo.addSelectionListener((SelectionListener)this);
            this.m_oldNameCombos.add(combo);
        }
        this.onSelected();
    }

    private void onSelected() {
        this.m_replaceExecTestCasesData.setOldParameterNamesWithCombos(this.m_oldNameCombos);
        this.updateAdditionalInformation();
    }

    private void updateAdditionalInformation() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.m_replaceExecTestCasesData.haveNewAndOldTestCasesNoParameters()) {
            messages.add(Messages.ReplaceTCRWizard_matchParameterNames_hintNoMatchingNeeded);
        } else {
            if (this.m_replaceExecTestCasesData.hasUnmatchedNewParameters()) {
                messages.add(Messages.ReplaceTCRWizard_matchParameterNames_hintUnmatchedNewParam);
            }
            if (this.m_replaceExecTestCasesData.hasUnmatchedOldParameters()) {
                messages.add(Messages.ReplaceTCRWizard_matchParameterNames_hintUnmatchedOldParam);
            }
        }
        this.setAdditionalInformation(messages);
    }

    private static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    public void performHelp() {
        Plugin.getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.searchRefactorReplaceExecutionTestCaseWizardContextId");
    }

    public boolean isPageComplete() {
        return this.isCurrentPage();
    }

    public void widgetSelected(SelectionEvent e) {
        this.onSelected();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.onSelected();
    }
}

