/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.awt.Point;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.ListTester;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.RobotJavaFXImpl;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.NodeTraverseHelper;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class ListViewTester
extends ListTester {
    public void rcDragValue(int mouseButton, String modifier, String value, String operator, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelectValue(value, operator, searchType, ValueSets.BinaryChoice.no.rcValue(), mouseButton, 0);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropValue(String value, String operator, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.rcSelectValue(value, operator, searchType, ValueSets.BinaryChoice.no.rcValue(), dndHelper.getMouseButton(), 0);
            ListViewTester.waitBeforeDrop((int)delayBeforeDrop);
            ((RobotJavaFXImpl)this.getRobot()).shakeMouse();
        }
        finally {
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragIndex(int mouseButton, String modifier, int index) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelectIndex(String.valueOf(index), ValueSets.BinaryChoice.no.rcValue(), mouseButton, 0);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropIndex(int index, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.rcSelectIndex(String.valueOf(index), ValueSets.BinaryChoice.no.rcValue(), dndHelper.getMouseButton(), 0);
            ListViewTester.waitBeforeDrop((int)delayBeforeDrop);
            ((RobotJavaFXImpl)this.getRobot()).shakeMouse();
        }
        finally {
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        Point awtPoint = this.getRobot().getCurrentMousePosition();
        final Point2D point = new Point2D((double)awtPoint.x, (double)awtPoint.y);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeAtMousePosition", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((ListView)ListViewTester.this.getRealComponent()).layout();
                List<ListCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)ListViewTester.this.getRealComponent(), ListCell.class);
                for (ListCell cell : tCells) {
                    if (!NodeBounds.checkIfContains(point, (Node)cell)) continue;
                    return cell;
                }
                throw new StepExecutionException("No table node found at mouse position: X: " + point.getX() + "Y: " + point.getY(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
        return result;
    }
}

