/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the ApplicationActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-25T08:17:59.649Z")
@Beta
public class ApplicationActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.ApplicationActionHandler {
            public ApplicationActionHandler() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        /**
         * Performs arbitrary clicks into the currently active AUT window
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public void clickInActiveWindow(
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (numberOfClicks == null) return;
            
            if (mouseButton == null) return;
            
            if (xPosition == null) return;
            
            if (xUnits == null) return;
            
            if (yPosition == null) return;
            
            if (yUnits == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickDirect")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param activationMethod 
         *        the AUT activation method to use
         * 
         */
        public void activate(
            @Nullable AUTActivationMethod activationMethod
        )  {
            if (activationMethod == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcActivate")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(activationMethod.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * 
         */
        public void inputText(
            @Nullable String text
        )  {
            if (text == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInputText")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(text)
                            .build(), null);
        }
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * 
         */
        public void keyCombination(
            @Nullable Modifier[] modifierKeys,
            @Nullable String baseKey
        )  {
            if (modifierKeys == null) return;
            
            if (baseKey == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcKeyStroke")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(baseKey)
                            .build(), null);
        }
        
        /**
         * 
         * @param key 
         *        the toggle key
         * @param activateKey 
         *        the activate key
         * 
         */
        public void setToggleKey(
            @Nullable Integer key,
            @Nullable Boolean activateKey
        )  {
            if (key == null) return;
            
            if (activateKey == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcToggle")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(key)
                            .addParameter(activateKey)
                            .build(), null);
        }
        
        /**
         * 
         * @param millisecs 
         *        the amount of milliseconds
         * 
         */
        public void delay(
            @Nullable Integer millisecs
        )  {
            if (millisecs == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcWait")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(millisecs)
                            .build(), null);
        }
        
        public void pauseTestExecution(
        )  {
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcPause")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .build(), null);
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * 
         */
        public void waitForWindow(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (timeoutInMs == null) return;
            
            if (delayAfterVisibility == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcWaitForWindow")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .addParameter(delayAfterVisibility)
                            .build(), null);
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * 
         */
        public void waitForWindowActivation(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (timeoutInMs == null) return;
            
            if (delayAfterVisibility == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcWaitForWindowActivation")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .addParameter(delayAfterVisibility)
                            .build(), null);
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterClosure 
         *        the static delay after closure
         * 
         */
        public void waitForWindowToClose(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterClosure
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (timeoutInMs == null) return;
            
            if (delayAfterClosure == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcWaitForWindowToClose")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .addParameter(delayAfterClosure)
                            .build(), null);
        }
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * 
         */
        public void takeScreenshot(
            @Nullable String destination,
            @Nullable Integer delay,
            @Nullable String fileAccess,
            @Nullable Integer scalingFactor,
            @Nullable Boolean createDirectories
        )  {
            if (destination == null) return;
            
            if (delay == null) return;
            
            if (fileAccess == null) return;
            
            if (scalingFactor == null) return;
            
            if (createDirectories == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcTakeScreenshot")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(destination)
                            .addParameter(delay)
                            .addParameter(fileAccess)
                            .addParameter(scalingFactor)
                            .addParameter(createDirectories)
                            .build(), null);
        }
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * 
         */
        public void externalKeyCombination(
            @Nullable Modifier[] modifierKeys,
            @Nullable String baseKey
        )  {
            if (modifierKeys == null) return;
            
            if (baseKey == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcNativeKeyStroke")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(baseKey)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * 
         */
        public void externalInputText(
            @Nullable String text
        )  {
            if (text == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcNativeInputText")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(text)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * 
         */
        public void copyTextToClipboard(
            @Nullable String text
        )  {
            if (text == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCopyToClipboard")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(text)
                            .build(), null);
        }
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param comparisonMethod 
         *        the comparison method
         * @param value2 
         *        the second value
         * @since 4.0
         */
        public void checkNumericValues(
            @Nullable String value1,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable String value2
        )  {
            if (value1 == null) return;
            
            if (comparisonMethod == null) return;
            
            if (value2 == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckValues")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(value1)
                            .addParameter(comparisonMethod.rcValue())
                            .addParameter(value2)
                            .build(), null);
        }
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @param marginTop 
         *        the top margin
         * @param marginRight 
         *        the right margin
         * @param marginBottom 
         *        the bottom margin
         * @param marginLeft 
         *        the left margin
         * 
         */
        public void takeScreenshotOfActiveWindow(
            @Nullable String destination,
            @Nullable Integer delay,
            @Nullable String fileAccess,
            @Nullable Integer scalingFactor,
            @Nullable Boolean createDirectories,
            @Nullable Integer marginTop,
            @Nullable Integer marginRight,
            @Nullable Integer marginBottom,
            @Nullable Integer marginLeft
        )  {
            if (destination == null) return;
            
            if (delay == null) return;
            
            if (fileAccess == null) return;
            
            if (scalingFactor == null) return;
            
            if (createDirectories == null) return;
            
            if (marginTop == null) return;
            
            if (marginRight == null) return;
            
            if (marginBottom == null) return;
            
            if (marginLeft == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcTakeScreenshotOfActiveWindow")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(destination)
                            .addParameter(delay)
                            .addParameter(fileAccess)
                            .addParameter(scalingFactor)
                            .addParameter(createDirectories)
                            .addParameter(marginTop)
                            .addParameter(marginRight)
                            .addParameter(marginBottom)
                            .addParameter(marginLeft)
                            .build(), null);
        }
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param value2Operator 
         *        the operator used for comparison with value 2
         * @param value2 
         *        the second value
         * 
         */
        public void checkStringValues(
            @Nullable String value1,
            @Nullable String value2Operator,
            @Nullable String value2
        )  {
            if (value1 == null) return;
            
            if (value2Operator == null) return;
            
            if (value2 == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckStringValues")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(value1)
                            .addParameter(value2Operator)
                            .addParameter(value2)
                            .build(), null);
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * 
         */
        public void checkExistenceOfWindow(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (exists == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckExistenceOfWindow")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .build(), null);
        }
        
} 