/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.gef.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the {@link org.eclipse.draw2d.FigureCanvas} component from the gef toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@TesterClass(testerClass="org.eclipse.jubula.rc.rcp.e3.gef.tester.FigureCanvasTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-25T08:17:59.614Z")
@Beta
public class FigureCanvasActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.GraphicsComponentActionHandler implements org.eclipse.jubula.toolkit.gef.components.handler.FigureCanvasActionHandler {
            public FigureCanvasActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * 
         */
        public void checkFigureExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (exists == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckFigureExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * 
         */
        public void checkToolExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (exists == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckToolExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void clickFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (numberOfClicks == null) return;
            
            if (mouseButton == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public void clickInFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (numberOfClicks == null) return;
            
            if (mouseButton == null) return;
            
            if (xPosition == null) return;
            
            if (xUnits == null) return;
            
            if (yPosition == null) return;
            
            if (yUnits == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickInFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public void selectTool(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (numberOfClicks == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectTool")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .build(), null);
        }
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public void clickConnection(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        )  {
            if (sourceTextPath == null) return;
            
            if (sourceOperator == null) return;
            
            if (targetTextPath == null) return;
            
            if (targetOperator == null) return;
            
            if (numberOfClicks == null) return;
            
            if (mouseButton == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickConnection")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param exists 
         *        whether existence is expected or not
         * @since 4.0
         */
        public void checkConnectionExistence(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Boolean exists
        )  {
            if (sourceTextPath == null) return;
            
            if (sourceOperator == null) return;
            
            if (targetTextPath == null) return;
            
            if (targetOperator == null) return;
            
            if (exists == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckConnectionExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(exists)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public void dragFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (mouseButton == null) return;
            
            if (modifierKeys == null) return;
            
            if (xPosition == null) return;
            
            if (xUnits == null) return;
            
            if (yPosition == null) return;
            
            if (yUnits == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public void dropOnFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (xPosition == null) return;
            
            if (xUnits == null) return;
            
            if (yPosition == null) return;
            
            if (yUnits == null) return;
            
            if (delayBeforeDropMilliseconds == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropOnFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * 
         */
        public void checkFigureProperty(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator
        )  {
            if (textpath == null) return;
            
            if (textOperator == null) return;
            
            if (propertyName == null) return;
            
            if (propertyValue == null) return;
            
            if (valueOperator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyFigureProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(textOperator.rcValue())
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(valueOperator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param anchorType 
         *        the anchor type
         * @param numberOfAnchors 
         *        Number of Anchors
         * @param comparisonMethod 
         *        the comparison method
         * @since 4.0
         */
        public void checkAnchorCount(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable AnchorType anchorType,
            @Nullable Integer numberOfAnchors,
            @Nullable NumberComparisonOperator comparisonMethod
        )  {
            if (textpath == null) return;
            
            if (textOperator == null) return;
            
            if (anchorType == null) return;
            
            if (numberOfAnchors == null) return;
            
            if (comparisonMethod == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckNumberOfAnchors")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(textOperator.rcValue())
                            .addParameter(anchorType.rcValue())
                            .addParameter(numberOfAnchors)
                            .addParameter(comparisonMethod.rcValue())
                            .build(), null);
        }
        
        /**
         * Verifies if an anchor has a connection or not
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param hasConnection 
         *        whether a connection is expected or not
         * @since 4.0
         */
        public void checkAnchorHasConnection(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean hasConnection
        )  {
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (hasConnection == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckAnchorConnection")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(hasConnection)
                            .build(), null);
        }
        
        /**
         * Checks a property from a Figure in a ConnectionEditPart
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @since 4.0
         */
        public void checkConnectionFigureProperty(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator
        )  {
            if (sourceTextPath == null) return;
            
            if (sourceOperator == null) return;
            
            if (targetTextPath == null) return;
            
            if (targetOperator == null) return;
            
            if (propertyName == null) return;
            
            if (propertyValue == null) return;
            
            if (valueOperator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyConnectionProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(valueOperator.rcValue())
                            .build(), null);
        }
        
} 