/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the BrowserActionHandler component from the html toolkit.
 * @since 4.0
 */
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.HtmlApplicationImplClass")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-25T08:17:59.766Z")
@Beta
public class BrowserActionHandler implements org.eclipse.jubula.toolkit.html.components.handler.BrowserActionHandler {
            public BrowserActionHandler() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =
            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();
        pseudoIdentifier.setComponentClassName("com.bredexsw.guidancer.webautserver.web.implclasses.WebBrowser"); //$NON-NLS-1$
        return pseudoIdentifier;
    }
    
        /**
         * 
         * @param uRL 
         *        the URL top open
         * 
         */
        public void openURL(
            @Nullable String uRL
        )  {
            if (uRL == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcGotoUrl")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(uRL)
                            .build(), null);
        }
        
        public void goBack(
        )  {
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcBack")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .build(), null);
        }
        
        public void reloadPage(
        )  {
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcReload")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .build(), null);
        }
        
        /**
         * 
         * @param identifier 
         *        the identifier to use
         * @param identifierType 
         *        the identifier type to use
         * 
         */
        public void selectWindowWithIdentifier(
            @Nullable String identifier,
            @Nullable String identifierType
        )  {
            if (identifier == null) return;
            
            if (identifierType == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectWindowByIdentifier")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(identifier)
                            .addParameter(identifierType)
                            .build(), null);
        }
        
        /**
         * 
         * @param windowTitle 
         *        the browser window title
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public void selectWindowWithTitle(
            @Nullable String windowTitle,
            @Nullable Operator operator
        )  {
            if (windowTitle == null) return;
            
            if (operator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectWindow")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(windowTitle)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
} 