/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.core;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.WARProductModelFactory;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IAboutInfo;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.ICSSInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationProperty;
import org.eclipse.pde.internal.core.iproduct.IIntroInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.ILicenseInfo;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IPreferencesInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.iproduct.IRepositoryInfo;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.core.util.PDEXMLHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WARProduct
implements IWARProduct {
    private static final long serialVersionUID = -8956436490095281273L;
    private IProduct delegate;
    private Map libraries;
    private IPath webXmlPath;
    private IPath launchIniPath;
    private IPreferencesInfo fPreferencesInfo;
    private ICSSInfo fCSSInfo;

    public WARProduct(IProduct delegate) {
        this.delegate = delegate;
        this.libraries = new HashMap();
    }

    public void addLibrary(IPath libraryPath, boolean fromTarget) {
        boolean modified;
        Object containedPath = this.libraries.get(libraryPath);
        boolean bl = modified = containedPath == null;
        if (modified) {
            this.libraries.put(libraryPath, fromTarget);
        }
        if (this.getModel().isEditable() && modified) {
            this.fireStructureChanged(new IPath[]{libraryPath}, 1);
        }
    }

    public void removeLibrary(IPath libraryPath) {
        Object containedPath = this.libraries.get(libraryPath);
        boolean modified = containedPath != null;
        this.libraries.remove(libraryPath);
        if (this.getModel().isEditable() && modified) {
            this.fireStructureChanged(new IPath[]{libraryPath}, 2);
        }
    }

    public void removeLibraries(IPath[] pathes) {
        int i = 0;
        while (i < pathes.length) {
            this.removeLibrary(pathes[i]);
            ++i;
        }
    }

    public IPath[] getLibraries() {
        IPath[] result = new IPath[this.libraries.size()];
        Set keySet = this.libraries.keySet();
        keySet.toArray(result);
        return result;
    }

    public boolean isLibraryFromTarget(IPath libraryPath) {
        Boolean result = (Boolean)this.libraries.get(libraryPath);
        return result;
    }

    public boolean contiansLibrary(IPath relativeWorkspacePath) {
        Object containedPath = this.libraries.get(relativeWorkspacePath);
        return containedPath != null;
    }

    public void addWebXml(IPath relativeWorkspacePath) {
        this.webXmlPath = relativeWorkspacePath;
    }

    public IPath getWebXml() {
        return this.webXmlPath;
    }

    public void addLaunchIni(IPath relativeWorkspacePath) {
        this.launchIniPath = relativeWorkspacePath;
    }

    public IPath getLaunchIni() {
        return this.launchIniPath;
    }

    public void write(String indent, PrintWriter writer) {
        this.writeMetaInfos(indent, writer);
        this.writePlugins(indent, writer);
        this.writeFeatures(indent, writer);
        this.writePluginConfigurations(indent, writer);
        this.writeWARInfo(indent, writer);
        this.writeCloseProduct(writer);
    }

    private void writeMetaInfos(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<product");
        if (this.getName() != null && this.getName().length() > 0) {
            writer.print(" name=\"" + this.getWritableString(this.getName()) + "\"");
        }
        if (this.getId() != null && this.getId().length() > 0) {
            writer.print(" uid=\"" + this.getId() + "\"");
        }
        if (this.getProductId() != null && this.getProductId().length() > 0) {
            writer.print(" id=\"" + this.getProductId() + "\"");
        }
        if (this.getVersion() != null && this.getVersion().length() > 0) {
            writer.print(" version=\"" + this.getVersion() + "\"");
        }
        writer.print(" useFeatures=\"" + Boolean.toString(this.useFeatures()) + "\"");
        writer.print(" includeLaunchers=\"" + Boolean.toString(this.includeLaunchers()) + "\"");
        writer.println(">");
    }

    private void writePlugins(String indent, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "   <plugins>");
        IProductPlugin[] plugins = this.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IProductPlugin plugin = plugins[i];
            plugin.write(String.valueOf(indent) + "      ", writer);
            ++i;
        }
        writer.println(String.valueOf(indent) + "   </plugins>");
    }

    private void writeFeatures(String indent, PrintWriter writer) {
        IProductFeature[] features = this.getFeatures();
        if (features.length > 0) {
            writer.println();
            writer.println(String.valueOf(indent) + "   <features>");
            int i = 0;
            while (i < features.length) {
                IProductFeature feature = features[i];
                feature.write(String.valueOf(indent) + "      ", writer);
                ++i;
            }
            writer.println(String.valueOf(indent) + "   </features>");
        }
        writer.println();
    }

    private void writePluginConfigurations(String indent, PrintWriter writer) {
        IPluginConfiguration[] pluginConfigurations = this.getPluginConfigurations();
        if (pluginConfigurations != null && pluginConfigurations.length > 0) {
            writer.println(String.valueOf(indent) + "   <configurations>");
            int i = 0;
            while (i < pluginConfigurations.length) {
                IPluginConfiguration configuration = pluginConfigurations[i];
                configuration.write(String.valueOf(indent) + "      ", writer);
                ++i;
            }
            writer.println(String.valueOf(indent) + "   </configurations>");
        }
        writer.println();
    }

    private void writeWARInfo(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "   <warConfiguration");
        if (this.webXmlPath != null) {
            writer.write(" webXml=\"" + this.webXmlPath.toPortableString() + "\"");
        }
        if (this.launchIniPath != null) {
            writer.write(" launchIni=\"" + this.launchIniPath.toPortableString() + "\"");
        }
        writer.println(">");
        if (this.libraries.size() > 0) {
            writer.println("   <libraries>");
            IPath[] pathes = new IPath[this.libraries.size()];
            this.libraries.keySet().toArray(pathes);
            int i = 0;
            while (i < pathes.length) {
                String libraryPath = pathes[i].toPortableString();
                Boolean fromTarget = (Boolean)this.libraries.get(pathes[i]);
                writer.println("      <library path=\"" + libraryPath + "\" fromTarget=\"" + fromTarget + "\"/>");
                ++i;
            }
            writer.println("   </libraries>");
        }
        writer.println(String.valueOf(indent) + "   </warConfiguration>");
    }

    private void writeCloseProduct(PrintWriter writer) {
        writer.println("</product>");
    }

    public String getWritableString(String source) {
        return PDEXMLHelper.getWritableString((String)source);
    }

    public void parse(Node node) {
        this.delegate.parse(node);
        if (node.getNodeType() == 1 && node.getNodeName().equals("product")) {
            this.parseInfo(node);
        }
    }

    private void parseInfo(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String name;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (name = child.getNodeName()).equals("warConfiguration")) {
                this.parseWARConfiguration(child);
            }
            ++i;
        }
    }

    private void parseWARConfiguration(Node child) {
        this.processWARConfigurationAttributes(child);
        this.processLibrary(child);
    }

    private void processWARConfigurationAttributes(Node child) {
        Node launchIniNode;
        NamedNodeMap attributes = child.getAttributes();
        Node webXmlNode = attributes.getNamedItem("webXml");
        if (webXmlNode != null) {
            String webXml = this.getValidPath(webXmlNode.getNodeValue());
            this.webXmlPath = new Path(webXml);
        }
        if ((launchIniNode = attributes.getNamedItem("launchIni")) != null) {
            String launchIni = this.getValidPath(launchIniNode.getNodeValue());
            this.launchIniPath = new Path(launchIni);
        }
    }

    private void processLibrary(Node child) {
        NodeList children = child.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1 && childNode.getNodeName().equals("libraries")) {
                this.processLibraries(childNode);
            }
            ++i;
        }
    }

    private void processLibraries(Node child) {
        NodeList children = child.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1 && childNode.getNodeName().equals("library")) {
                NamedNodeMap attributes = childNode.getAttributes();
                Node pathItem = attributes.getNamedItem("path");
                Node fromTargetString = attributes.getNamedItem("fromTarget");
                Boolean fromTarget = Boolean.valueOf(fromTargetString.getNodeValue());
                String libPath = this.getValidPath(pathItem.getNodeValue());
                this.libraries.put(new Path(libPath), fromTarget);
            }
            ++i;
        }
    }

    private String getValidPath(String path) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length()) {
            char charAt = path.charAt(i);
            if (charAt == '/' || charAt == '\\') {
                charAt = File.separatorChar;
            }
            buffer.append(charAt);
            ++i;
        }
        return buffer.toString();
    }

    public void reset() {
        this.delegate.reset();
        this.webXmlPath = null;
        this.launchIniPath = null;
        this.libraries.clear();
    }

    public IPluginConfiguration[] getPluginConfigurations() {
        ArrayList<IPluginConfiguration> containedBundles = new ArrayList<IPluginConfiguration>();
        IProductPlugin[] plugins = this.getPlugins();
        if (plugins != null && plugins.length > 0) {
            WARProductModelFactory factory = new WARProductModelFactory(this.getModel());
            int i = 0;
            while (i < plugins.length) {
                String pluginId = plugins[i].getId();
                if (!this.isBundleFragment(pluginId)) {
                    IPluginConfiguration conf = factory.createPluginConfiguration();
                    conf.setId(pluginId);
                    conf.setAutoStart(true);
                    containedBundles.add(conf);
                }
                ++i;
            }
        }
        IPluginConfiguration[] result = new IPluginConfiguration[containedBundles.size()];
        containedBundles.toArray(result);
        return result;
    }

    private boolean isBundleFragment(String pluginId) {
        boolean result = false;
        ModelEntry entry = PluginRegistry.findEntry((String)pluginId);
        if (entry != null) {
            IPluginModelBase[] models = entry.getActiveModels();
            int i = 0;
            while (i < models.length && !result) {
                result = models[i].isFragmentModel();
                ++i;
            }
        }
        return result;
    }

    protected void fireStructureChanged(Object child, int changeType) {
        this.fireStructureChanged(new Object[]{child}, changeType);
    }

    protected void fireStructureChanged(Object[] children, int changeType) {
        if (this.getModel().isEditable()) {
            IProductModel provider = this.getModel();
            provider.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)provider, changeType, children, null));
        }
    }

    public boolean includeLaunchers() {
        return false;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getProductId() {
        return this.delegate.getProductId();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getApplication() {
        return this.delegate.getApplication();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public String getDefiningPluginId() {
        return this.delegate.getDefiningPluginId();
    }

    public boolean useFeatures() {
        return this.delegate.useFeatures();
    }

    public IAboutInfo getAboutInfo() {
        return this.delegate.getAboutInfo();
    }

    public IConfigurationFileInfo getConfigurationFileInfo() {
        return this.delegate.getConfigurationFileInfo();
    }

    public IArgumentsInfo getLauncherArguments() {
        return this.delegate.getLauncherArguments();
    }

    public IJREInfo getJREInfo() {
        return this.delegate.getJREInfo();
    }

    public IWindowImages getWindowImages() {
        return this.delegate.getWindowImages();
    }

    public ISplashInfo getSplashInfo() {
        return this.delegate.getSplashInfo();
    }

    public IIntroInfo getIntroInfo() {
        return this.delegate.getIntroInfo();
    }

    public ILauncherInfo getLauncherInfo() {
        return this.delegate.getLauncherInfo();
    }

    public ILicenseInfo getLicenseInfo() {
        return this.delegate.getLicenseInfo();
    }

    public void addPlugins(IProductPlugin[] plugin) {
        this.delegate.addPlugins(plugin);
    }

    public void addFeatures(IProductFeature[] feature) {
        this.delegate.addFeatures(feature);
    }

    public void addPluginConfigurations(IPluginConfiguration[] configurations) {
        this.delegate.addPluginConfigurations(configurations);
    }

    public void removePlugins(IProductPlugin[] plugins) {
        this.delegate.removePlugins(plugins);
    }

    public void removeFeatures(IProductFeature[] feature) {
        this.delegate.removeFeatures(feature);
    }

    public void removePluginConfigurations(IPluginConfiguration[] configurations) {
        this.delegate.removePluginConfigurations(configurations);
    }

    public IPluginConfiguration findPluginConfiguration(String id) {
        return this.delegate.findPluginConfiguration(id);
    }

    public IProductPlugin[] getPlugins() {
        return this.delegate.getPlugins();
    }

    public IProductFeature[] getFeatures() {
        return this.delegate.getFeatures();
    }

    public void setId(String id) {
        this.delegate.setId(id);
    }

    public void setProductId(String id) {
        this.delegate.setProductId(id);
    }

    public void setVersion(String version) {
        this.delegate.setVersion(version);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setAboutInfo(IAboutInfo info) {
        this.delegate.setAboutInfo(info);
    }

    public void setApplication(String application) {
        this.delegate.setApplication(application);
    }

    public void setConfigurationFileInfo(IConfigurationFileInfo info) {
        this.delegate.setConfigurationFileInfo(info);
    }

    public void setLauncherArguments(IArgumentsInfo info) {
        this.delegate.setLauncherArguments(info);
    }

    public void setJREInfo(IJREInfo info) {
        this.delegate.setJREInfo(info);
    }

    public void setWindowImages(IWindowImages images) {
        this.delegate.setWindowImages(images);
    }

    public void setSplashInfo(ISplashInfo info) {
        this.delegate.setSplashInfo(info);
    }

    public void setIntroInfo(IIntroInfo introInfo) {
        this.delegate.setIntroInfo(introInfo);
    }

    public void setLauncherInfo(ILauncherInfo info) {
        this.delegate.setLauncherInfo(info);
    }

    public void setLicenseInfo(ILicenseInfo info) {
        this.delegate.setLicenseInfo(info);
    }

    public void setUseFeatures(boolean use) {
        this.delegate.setUseFeatures(use);
    }

    public void setIncludeLaunchers(boolean exclude) {
        this.delegate.setIncludeLaunchers(exclude);
    }

    public void swap(IProductFeature feature1, IProductFeature feature2) {
        this.delegate.swap(feature1, feature2);
    }

    public boolean containsPlugin(String id) {
        return this.delegate.containsPlugin(id);
    }

    public boolean containsFeature(String id) {
        return this.delegate.containsFeature(id);
    }

    public IProductModel getModel() {
        return this.delegate.getModel();
    }

    public void setModel(IProductModel model) {
        this.delegate.setModel(model);
    }

    public IProduct getProduct() {
        return this.delegate.getProduct();
    }

    public void addConfigurationProperties(IConfigurationProperty[] properties) {
        this.delegate.addConfigurationProperties(properties);
    }

    public void removeConfigurationProperties(IConfigurationProperty[] properties) {
        this.delegate.removeConfigurationProperties(properties);
    }

    public IConfigurationProperty[] getConfigurationProperties() {
        return this.delegate.getConfigurationProperties();
    }

    public IRepositoryInfo[] getRepositories() {
        return null;
    }

    public void removeRepositories(IRepositoryInfo[] repositories) {
    }

    public void addRepositories(IRepositoryInfo[] repositories) {
    }

    public IPreferencesInfo getPreferencesInfo() {
        return this.fPreferencesInfo;
    }

    public void setPreferencesInfo(IPreferencesInfo info) {
        this.fPreferencesInfo = info;
    }

    public ICSSInfo getCSSInfo() {
        return this.fCSSInfo;
    }

    public void setCSSInfo(ICSSInfo info) {
        this.fCSSInfo = info;
    }
}

