/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.internal.docker.core.ProcessMessages;

@Deprecated
public class ProcessUtils {
    public static boolean checkPathToCommand(String path, String cmdName) {
        return Stream.of(path.split(File.pathSeparator)).map(pathFragment -> new File((String)pathFragment, cmdName)).anyMatch(fullPath -> fullPath.exists());
    }

    public static FluentProcessBuilder processBuilder(String baseCmdDir, String cmdName, String ... args) throws DockerException {
        return new FluentProcessBuilder(baseCmdDir, cmdName, args);
    }

    public static class AsyncProcessRunner {
        private final ProcessBuilder processBuilder;
        private final Consumer<String> outputConsumer;

        public AsyncProcessRunner(ProcessBuilder processBuilder, Consumer<String> outputConsumer) {
            this.processBuilder = processBuilder;
            this.outputConsumer = outputConsumer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Process start() throws DockerException {
            try {
                this.processBuilder.redirectErrorStream(true);
                Process process = this.processBuilder.start();
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    InputStream inputStream = process.getInputStream();
                    try {
                        try (BufferedReader buff = new BufferedReader(new InputStreamReader(inputStream));){
                            String line;
                            while ((line = buff.readLine()) != null) {
                                this.outputConsumer.accept(String.valueOf(line) + '\n');
                            }
                        }
                        if (inputStream == null) return process;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    return process;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DockerException(ProcessMessages.getFormattedString("Process_Exception", this.processBuilder.command().stream().collect(Collectors.joining(" ")), e.getMessage()), e);
            }
        }
    }

    public static class FluentProcessBuilder {
        private final ProcessBuilder processBuilder;

        private FluentProcessBuilder(String baseCmdDir, String cmdName, String[] args) throws DockerException {
            boolean commandExists = ProcessUtils.checkPathToCommand(baseCmdDir, cmdName);
            if (!commandExists) {
                throw new DockerException(ProcessMessages.getFormattedString("Command_Not_Found", baseCmdDir, cmdName));
            }
            String[] command = new String[args.length + 1];
            command[0] = Paths.get(baseCmdDir, cmdName).toString();
            System.arraycopy(args, 0, command, 1, args.length);
            this.processBuilder = new ProcessBuilder(command);
        }

        public FluentProcessBuilder extraPath(String ... extraPaths) {
            Map<String, String> environment = this.processBuilder.environment();
            StringBuilder path = new StringBuilder();
            String[] stringArray = extraPaths;
            int n = extraPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String extraPath = stringArray[n2];
                path.append(File.pathSeparator).append(extraPath);
                ++n2;
            }
            String newEnvPath = String.valueOf(environment.get("PATH")) + path.toString();
            environment.put("PATH", newEnvPath);
            return this;
        }

        public FluentProcessBuilder workingDir(String workingDir) {
            this.processBuilder.directory(new File(workingDir));
            return this;
        }

        public AsyncProcessRunner outputListener(Consumer<String> outputConsumer) {
            return new AsyncProcessRunner(this.processBuilder, outputConsumer);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String[] start() {
            try {
                StringBuffer errorMessage;
                Process p;
                block31: {
                    p = this.processBuilder.start();
                    p.waitFor();
                    if (p.exitValue() == 0) {
                        ArrayList<String> result = new ArrayList<String>();
                        Throwable throwable = null;
                        Object var4_9 = null;
                        try {
                            InputStream inputStream = p.getInputStream();
                            try {
                                try (BufferedReader buff = new BufferedReader(new InputStreamReader(inputStream));){
                                    String line;
                                    while ((line = buff.readLine()) != null) {
                                        result.add(line);
                                    }
                                }
                                if (inputStream == null) return result.toArray(new String[0]);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (inputStream == null) throw throwable;
                                inputStream.close();
                                throw throwable;
                            }
                            inputStream.close();
                            return result.toArray(new String[0]);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    errorMessage = new StringBuffer();
                    Throwable throwable = null;
                    Object var4_12 = null;
                    try {
                        InputStream errorStream = p.getErrorStream();
                        try {
                            try (BufferedReader buff = new BufferedReader(new InputStreamReader(errorStream));){
                                String line;
                                while ((line = buff.readLine()) != null) {
                                    errorMessage.append(line).append('\n');
                                }
                            }
                            if (errorStream == null) break block31;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            if (errorStream == null) throw throwable;
                            errorStream.close();
                            throw throwable;
                        }
                        errorStream.close();
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                            throw throwable;
                        }
                        if (throwable == throwable5) throw throwable;
                        throwable.addSuppressed(throwable5);
                        throw throwable;
                    }
                }
                Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.core", ProcessMessages.getFormattedString("Process_Error", this.processBuilder.command().stream().collect(Collectors.joining(" ")), p.exitValue(), errorMessage.toString())));
                return new String[0];
            }
            catch (IOException | InterruptedException e) {
                Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", ProcessMessages.getFormattedString("Process_Exception", this.processBuilder.command().stream().collect(Collectors.joining(" ")), e.getMessage()), (Throwable)e));
            }
            return new String[0];
        }
    }
}

