/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.Reconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.linuxtools.internal.docker.editor.DockerEditor;
import org.eclipse.linuxtools.internal.docker.editor.assist.CompletionProcessor;
import org.eclipse.linuxtools.internal.docker.editor.scanner.DockerCommentScanner;
import org.eclipse.linuxtools.internal.docker.editor.scanner.DockerInstructionScanner;
import org.eclipse.linuxtools.internal.docker.editor.syntax.SyntaxReconcilingStrategy;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class DockerConfiguration
extends TextSourceViewerConfiguration {
    private DockerEditor editor;

    public DockerConfiguration(DockerEditor editor) {
        this.editor = editor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new DockerCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__docker_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__docker_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new DockerInstructionScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        Reconciler reconciler = new Reconciler();
        SyntaxReconcilingStrategy strategy = new SyntaxReconcilingStrategy(this.editor);
        reconciler.setReconcilingStrategy((IReconcilingStrategy)strategy, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        CompletionProcessor cap = new CompletionProcessor();
        ca.setContentAssistProcessor((IContentAssistProcessor)cap, "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }
}

