/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor.syntax;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.docker.editor.scanner.InstructionWordRule;

public class SyntaxProblemReporter {
    private static final String LINE_SEP = System.getProperty("line.separator");

    public void checkAndApply(IDocument document, int offset, int length, IResource resource) throws CoreException, BadLocationException {
        SyntaxProblem[] problems;
        if (resource == null) {
            return;
        }
        boolean fullScan = offset == 0 && length == document.getLength();
        IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        ArrayList<IMarker> markersToDelete = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            int markerLineNr = (Integer)marker.getAttribute("lineNumber");
            int regionLineNr = document.getLineOfOffset(offset);
            if (fullScan || markerLineNr == regionLineNr) {
                markersToDelete.add(marker);
            }
            ++n2;
        }
        for (IMarker marker : markersToDelete) {
            marker.delete();
        }
        SyntaxProblem[] syntaxProblemArray = problems = this.check(document, offset, length);
        int n3 = problems.length;
        n = 0;
        while (n < n3) {
            SyntaxProblem problem = syntaxProblemArray[n];
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", problem.severity);
            marker.setAttribute("message", (Object)problem.message);
            marker.setAttribute("lineNumber", document.getLineOfOffset(problem.offset));
            marker.setAttribute("charStart", problem.offset);
            marker.setAttribute("charEnd", problem.offset + problem.length);
            ++n;
        }
    }

    public SyntaxProblem[] check(IDocument document, int offset, int length) throws BadLocationException {
        String region = document.get(offset, length);
        int lineCount = region.split(LINE_SEP).length;
        int startingLineNr = document.getLineOfOffset(offset);
        ArrayList<SyntaxProblem> problems = new ArrayList<SyntaxProblem>();
        int lineNr = startingLineNr;
        while (lineNr < startingLineNr + lineCount) {
            int lineOffset = document.getLineOffset(lineNr);
            int lineEnd = document.getLength();
            if (lineNr + startingLineNr + 1 < lineCount) {
                lineEnd = document.getLineOffset(lineNr + 1);
            }
            int endOfFirstWord = 0;
            while (endOfFirstWord < lineEnd - lineOffset) {
                if (Character.isWhitespace(document.getChar(lineOffset + endOfFirstWord))) break;
                ++endOfFirstWord;
            }
            String firstWord = document.get(lineOffset, endOfFirstWord);
            if (!firstWord.trim().isEmpty() && !firstWord.trim().startsWith("#")) {
                String matchingInstruction = null;
                String[] stringArray = InstructionWordRule.INSTRUCTIONS;
                int n = InstructionWordRule.INSTRUCTIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String instr = stringArray[n2];
                    if (instr.equalsIgnoreCase(firstWord)) {
                        matchingInstruction = instr;
                        break;
                    }
                    ++n2;
                }
                if (matchingInstruction == null) {
                    problems.add(new SyntaxProblem(2, lineOffset, firstWord.length(), "Unknown instruction: " + firstWord));
                } else if (!matchingInstruction.equals(firstWord)) {
                    problems.add(new SyntaxProblem(1, lineOffset, firstWord.length(), "Instructions should be upper case"));
                }
            }
            ++lineNr;
        }
        return problems.toArray(new SyntaxProblem[problems.size()]);
    }

    public static class SyntaxProblem {
        public int severity;
        public int offset;
        public int length;
        public String message;

        public SyntaxProblem(int severity, int offset, int length, String message) {
            this.severity = severity;
            this.offset = offset;
            this.length = length;
            this.message = message;
        }
    }
}

