/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DockerConnectionWatcher
implements ISelectionListener {
    private static DockerConnectionWatcher instance;
    private IDockerConnection connection;

    public static DockerConnectionWatcher getInstance() {
        if (instance == null) {
            instance = new DockerConnectionWatcher();
        }
        return instance;
    }

    private DockerConnectionWatcher() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
    }

    public void setConnection(IDockerConnection connection) {
        this.connection = connection;
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            this.setConnection(null);
            return;
        }
        Object firstSegment = treeSelection.getPaths()[0].getFirstSegment();
        if (firstSegment instanceof IDockerConnection) {
            this.setConnection((IDockerConnection)firstSegment);
        }
    }
}

