/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshCommandHandler
extends AbstractHandler {
    public static final String CONTAINERS_REFRESH_MSG = "ContainersRefresh.msg";
    public static final String IMAGES_REFRESH_MSG = "ImagesRefresh.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        Job job = this.getRefreshJob(activePart);
        if (job != null) {
            job.setPriority(30);
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    private Job getRefreshJob(IWorkbenchPart activePart) {
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        if (activePart instanceof DockerImagesView) {
            return this.getRefreshImagesJob(connection);
        }
        if (activePart instanceof DockerContainersView) {
            return this.getRefreshContainersJob(connection);
        }
        if (activePart instanceof DockerExplorerView) {
            DockerExplorerView dockerExplorerView = (DockerExplorerView)activePart;
            ITreeSelection selection = dockerExplorerView.getCommonViewer().getStructuredSelection();
            if (selection.getFirstElement() instanceof DockerExplorerContentProvider.DockerContainersCategory) {
                return this.getRefreshContainersJob(connection);
            }
            if (selection.getFirstElement() instanceof DockerExplorerContentProvider.DockerImagesCategory) {
                return this.getRefreshImagesJob(connection);
            }
        }
        return null;
    }

    private Job getRefreshContainersJob(final IDockerConnection connection) {
        if (connection == null) {
            return null;
        }
        Job job = new Job(DVMessages.getString(CONTAINERS_REFRESH_MSG)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(RefreshCommandHandler.CONTAINERS_REFRESH_MSG), 1);
                connection.getContainers(true);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private Job getRefreshImagesJob(final IDockerConnection connection) {
        if (connection == null) {
            return null;
        }
        Job job = new Job(DVMessages.getString(IMAGES_REFRESH_MSG)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(RefreshCommandHandler.IMAGES_REFRESH_MSG), 1);
                connection.getImages(true);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        return job;
    }
}

