/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.jobs;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerImageBuildFailedException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerProgressMessage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.consoles.BuildConsole;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BuildDockerImageJob
extends Job
implements IDockerProgressHandler {
    private static final String BUILD_IMAGE_JOB_TITLE = "BuildImageJob.title";
    private static final String BUILD_IMAGE_ERROR_MESSAGE = "BuildImageError.msg";
    private static final String DOCKERFILE_LINE_COUNT_ERROR = "ImageBuildError.msg";
    private static final String SKIP_EMPTY_DOCKERFILE = "SkipEmptydockerfile.msg";
    private final IDockerConnection connection;
    private final IPath path;
    private final Map<String, Object> buildOptions;
    private final String repoName;
    private final int numberOfBuildOperations;
    private final BuildConsole console;
    private IProgressMonitor progressMonitor;

    public BuildDockerImageJob(IDockerConnection connection, IPath path, String repoName, Map<String, Object> buildOptions) throws DockerException {
        super(JobMessages.getString(BUILD_IMAGE_JOB_TITLE));
        this.connection = connection;
        this.path = path;
        this.repoName = repoName;
        this.buildOptions = buildOptions;
        this.console = BuildConsole.findConsole();
        this.numberOfBuildOperations = BuildDockerImageJob.countLines(path.addTrailingSeparator().append("Dockerfile").toOSString());
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        try {
            if (this.numberOfBuildOperations == 0) {
                Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.ui", JobMessages.getString(SKIP_EMPTY_DOCKERFILE)));
                this.progressMonitor = progressMonitor;
            } else {
                this.console.clearConsole();
                this.console.activate();
                this.progressMonitor = progressMonitor;
                this.progressMonitor.beginTask(JobMessages.getString(BUILD_IMAGE_JOB_TITLE), this.numberOfBuildOperations + 1);
                if (this.repoName == null) {
                    String name = "dockerfile:" + Long.toHexString(System.currentTimeMillis());
                    ((DockerConnection)this.connection).buildImage(this.path, name, (IDockerProgressHandler)this, this.buildOptions);
                } else {
                    ((DockerConnection)this.connection).buildImage(this.path, this.repoName, (IDockerProgressHandler)this, this.buildOptions);
                }
                this.connection.getImages(true);
            }
        }
        catch (InterruptedException | DockerException e) {
            Display.getDefault().syncExec(() -> BuildDockerImageJob.lambda$0((Exception)e));
        }
        this.progressMonitor.done();
        return Status.OK_STATUS;
    }

    public void processMessage(IDockerProgressMessage message) throws DockerException {
        if (message.error() != null) {
            this.cancel();
            throw new DockerImageBuildFailedException(message.error());
        }
        String status = message.stream();
        if (status != null && status.startsWith("Successfully built")) {
            this.connection.getImages(true);
        } else if (status != null && status.startsWith("Step")) {
            this.progressMonitor.worked(1);
        }
        this.logMessage(status);
    }

    private void logMessage(String buildMessage) {
        if (this.console != null && buildMessage != null) {
            Display.getDefault().asyncExec(() -> {
                this.console.showConsole();
                try {
                    this.console.write(buildMessage.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int countLines(String fileName) throws DockerException {
        try {
            int count = 0;
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fis = new FileInputStream(fileName);
                try {
                    block21: {
                        InputStreamReader isr = new InputStreamReader(fis);
                        try {
                            try (BufferedReader br = new BufferedReader(isr);){
                                String line;
                                while ((line = br.readLine()) != null) {
                                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                                    ++count;
                                }
                            }
                            if (isr == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (isr == null) throw throwable;
                            isr.close();
                            throw throwable;
                        }
                        isr.close();
                    }
                    if (fis == null) return count;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fis == null) throw throwable;
                    ((InputStream)fis).close();
                    throw throwable;
                }
                ((InputStream)fis).close();
                return count;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DockerException(JobMessages.getString(DOCKERFILE_LINE_COUNT_ERROR), (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$0(Exception exception) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JobMessages.getString(BUILD_IMAGE_ERROR_MESSAGE), (String)exception.getMessage());
    }
}

