/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class BaseResourceAwareLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IResource resource = (IResource)((IStructuredSelection)selection).toArray()[0];
            this.launch(resource, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch((IResource)editor.getEditorInput().getAdapter(IResource.class), mode);
    }

    protected ILaunchConfiguration findLaunchConfiguration(String configTypeId, IResource resource, Predicate<ILaunchConfiguration> predicate) {
        ILaunchConfigurationType configType = LaunchConfigurationUtils.getLaunchConfigType(configTypeId);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            Stream.of(configs).filter(predicate).forEach(config -> {
                boolean bl = candidateConfigs.add((ILaunchConfiguration)config);
            });
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(resource);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        return this.chooseConfiguration(candidateConfigs);
    }

    public static IPath getPath(String sourcePathLocation, boolean sourcePathWorkspaceRelativeLocation) {
        if (sourcePathWorkspaceRelativeLocation) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(sourcePathLocation));
            if (resource != null) {
                return resource.getLocation();
            }
            return new Path("");
        }
        return new Path(sourcePathLocation);
    }

    protected abstract ILaunchConfiguration createConfiguration(IResource var1);

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(LaunchMessages.getString("DockerComposeUpShortcutConfigSelection.title"));
        dialog.setMessage(LaunchMessages.getString("DockerComposeUpShortcutChooseLaunch.msg"));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getActiveWorkbenchShell() {
        return Activator.getActiveWorkbenchShell();
    }

    protected abstract void launch(IResource var1, String var2);
}

