/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ImageBuildPage
extends WizardPage {
    private static final String NAME = "ImageBuild.name";
    private static final String TITLE = "ImageBuild.title";
    private static final String DESC = "ImageBuild.desc";
    private static final String NAME_LABEL = "ImageBuildName.label";
    private static final String NAME_TOOLTIP = "ImageBuildName.toolTip";
    private static final String DIRECTORY_LABEL = "ImageBuildDirectory.label";
    private static final String DIRECTORY_TOOLTIP = "ImageBuildDirectory.toolTip";
    private static final String BROWSE_LABEL = "BrowseButton.label";
    private static final String EDIT_LABEL = "EditButton.label";
    private static final String NONEXISTENT_DIRECTORY = "ErrorNonexistentDirectory.msg";
    private static final String INVALID_DIRECTORY = "ErrorInvalidDirectory.msg";
    private static final String UNREADABLE_DIRECTORY = "ErrorUnreadableDirectory.msg";
    private static final String INVALID_ID = "ErrorInvalidImageId.msg";
    private static final String NO_DOCKER_FILE = "ErrorNoDockerFile.msg";
    private Text nameText;
    private Text directoryText;
    private Button editButton;
    private Set<IEditorPart> editors = new HashSet<IEditorPart>();
    private static String lastDirectoryPath;
    private ModifyListener Listener = e -> this.validate();

    public ImageBuildPage() {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public String getImageName() {
        return this.nameText.getText();
    }

    public String getDirectory() {
        return this.directoryText.getText();
    }

    public void dispose() {
        super.dispose();
        for (IEditorPart p : this.editors) {
            p.getEditorSite().getPage().closeEditor(p, true);
        }
        this.editors.clear();
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        String name = this.nameText.getText();
        if (name.length() > 0 && name.charAt(name.length() - 1) == ':') {
            this.setErrorMessage(WizardMessages.getString(INVALID_ID));
            error = true;
        } else if (name.contains(":") && name.substring(name.indexOf(58) + 1).contains(":")) {
            this.setErrorMessage(WizardMessages.getString(INVALID_ID));
            error = true;
        }
        if (!error) {
            String dir = this.directoryText.getText();
            if (dir.length() == 0) {
                this.editButton.setEnabled(false);
                complete = false;
            } else {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(dir));
                IFileInfo info = fileStore.fetchInfo();
                if (!info.exists()) {
                    error = true;
                    this.setErrorMessage(WizardMessages.getString(NONEXISTENT_DIRECTORY));
                } else if (!info.isDirectory()) {
                    error = true;
                    this.setErrorMessage(WizardMessages.getString(INVALID_DIRECTORY));
                } else if (!Files.isReadable(Paths.get(dir, new String[0]))) {
                    error = true;
                    this.setErrorMessage(WizardMessages.getString(UNREADABLE_DIRECTORY));
                } else {
                    this.editButton.setEnabled(true);
                    IFileStore dockerStore = fileStore.getChild("Dockerfile");
                    if (!dockerStore.fetchInfo().exists()) {
                        complete = false;
                        this.setMessage(WizardMessages.getString(NO_DOCKER_FILE), 1);
                    } else {
                        this.setMessage(null, 1);
                        lastDirectoryPath = dir;
                    }
                }
            }
        }
        if (!error) {
            this.setErrorMessage(null);
        } else {
            this.editButton.setEnabled(false);
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        final Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(WizardMessages.getString(NAME_LABEL));
        this.nameText = new Text(container, 2052);
        this.nameText.addModifyListener(this.Listener);
        this.nameText.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
        Label dirLabel = new Label(container, 0);
        dirLabel.setText(WizardMessages.getString(DIRECTORY_LABEL));
        this.directoryText = new Text(container, 2052);
        this.directoryText.addModifyListener(this.Listener);
        this.directoryText.setToolTipText(WizardMessages.getString(DIRECTORY_TOOLTIP));
        Button browse = new Button(container, 0);
        browse.setText(WizardMessages.getString(BROWSE_LABEL));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog d = new DirectoryDialog(container.getShell());
                String k = d.open();
                if (k != null) {
                    ImageBuildPage.this.directoryText.setText(k);
                }
            }
        });
        this.editButton = new Button(container, 0);
        this.editButton.setText(WizardMessages.getString(EDIT_LABEL));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = ImageBuildPage.this.directoryText.getText();
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(new Path(dir).append("Dockerfile"));
                java.nio.file.Path filePath = Paths.get(dir, "Dockerfile");
                if (!Files.exists(filePath, new LinkOption[0])) {
                    try {
                        Files.createFile(filePath, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart dockerFileEditor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    IWorkbenchPartSite site = page.getActivePart().getSite();
                    EModelService s = (EModelService)site.getService(EModelService.class);
                    MPartSashContainerElement p = (MPartSashContainerElement)site.getService(MPart.class);
                    s.detach(p, 100, 100, 500, 375);
                    ImageBuildPage.this.editors.add(dockerFileEditor);
                }
                catch (PartInitException e1) {
                    Activator.log(e1);
                }
                ImageBuildPage.this.validate();
            }
        });
        Point p1 = label.computeSize(-1, -1);
        Point p2 = this.directoryText.computeSize(-1, -1);
        Point p3 = browse.computeSize(-1, -1);
        int centering = (p2.y - p1.y + 1) / 2;
        int centering2 = (p3.y - p2.y + 1) / 2;
        FormData f = new FormData();
        f.top = new FormAttachment(0);
        label.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering + centering2);
        f.left = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering2);
        f.left = new FormAttachment((Control)dirLabel, 5);
        f.right = new FormAttachment((Control)browse, -10);
        this.nameText.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)nameLabel, 11 + centering + centering2);
        f.left = new FormAttachment(0, 0);
        dirLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)nameLabel, 11);
        f.right = new FormAttachment(100);
        this.editButton.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)nameLabel, 11);
        f.right = new FormAttachment((Control)this.editButton, -10);
        browse.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)nameLabel, 11 + centering2);
        f.left = new FormAttachment((Control)dirLabel, 5);
        f.right = new FormAttachment((Control)browse, -10);
        this.directoryText.setLayoutData((Object)f);
        if (lastDirectoryPath != null) {
            this.directoryText.setText(lastDirectoryPath);
        }
        this.setControl((Control)container);
        this.setPageComplete(false);
    }
}

