/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImageTagPage
extends WizardPage {
    private static final String NAME = "ImageTag.name";
    private static final String TITLE = "ImageTag.title";
    private static final String DESC = "ImageTag.desc";
    private static final String TAG_LABEL = "ImageTagName.label";
    private static final String TAG_TOOLTIP = "ImageTagName.toolTip";
    private Text tagText;
    private String tag;
    private ModifyListener Listener = e -> this.validate();

    public ImageTagPage(String imageName) {
        super(WizardMessages.getString(NAME));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setDescription(WizardMessages.getFormattedString(DESC, imageName));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public String getTag() {
        return this.tag;
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        String tagField = this.tagText.getText().trim();
        if (tagField.length() == 0) {
            complete = false;
        }
        if (!error) {
            this.setErrorMessage(null);
            this.tag = tagField;
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)container);
        Label repoLabel = new Label(container, 0);
        repoLabel.setText(WizardMessages.getString(TAG_LABEL));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)repoLabel);
        this.tagText = new Text(container, 2052);
        this.tagText.addModifyListener(this.Listener);
        this.tagText.setToolTipText(WizardMessages.getString(TAG_TOOLTIP));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.tagText);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }
}

